/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.mixin;

import com.hypherionmc.craterlib.client.gui.config.CraterConfigScreen;
import com.hypherionmc.craterlib.core.config.ConfigController;
import com.hypherionmc.craterlib.core.config.ModuleConfig;
import com.hypherionmc.craterlib.core.config.annotations.NoConfigScreen;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.forgespi.language.IModInfo;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ConfigScreenHandler.class})
public class ConfigScreenHandlerMixin {
    @Inject(at={@At(value="RETURN")}, method={"getScreenFactoryFor"}, cancellable=true, remap=false)
    private static void injectConfigScreen(IModInfo selectedMod, CallbackInfoReturnable<Optional<BiFunction<Minecraft, Screen, Screen>>> cir) {
        ConfigController.getMonitoredConfigs().forEach((conf, watcher) -> {
            ModuleConfig config;
            if (!conf.getClass().isAnnotationPresent(NoConfigScreen.class) && (config = (ModuleConfig)conf).getModId().equals(selectedMod.getModId())) {
                cir.setReturnValue(Optional.of((minecraft, screen) -> new CraterConfigScreen(config, (Screen)screen)));
            }
        });
    }
}

