/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.core.generated.operation;

import org.mtr.core.data.Position;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.serializer.SerializedDataBase;
import org.mtr.core.serializer.WriterBase;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;

public abstract class MSDDataRequestSchema
implements SerializedDataBase {
    protected final String clientId;
    protected final Position clientPosition;
    protected final long requestRadius;
    protected final ObjectArrayList<String> existingCatenaryIds = new ObjectArrayList();
    protected final ObjectArrayList<String> existingRigidCatenaryIds = new ObjectArrayList();
    private static final String KEY_CLIENT_ID = "client_id";
    private static final String KEY_CLIENT_POSITION = "client_position";
    private static final String KEY_REQUEST_RADIUS = "request_radius";
    private static final String KEY_EXISTING_CATENARY_IDS = "existing_catenary_ids";
    private static final String KEY_EXISTING_RIGID_CATENARY_IDS = "existing_rigid_catenary_ids";

    protected MSDDataRequestSchema(String clientId, Position clientPosition, long requestRadius) {
        this.clientId = clientId;
        this.clientPosition = clientPosition;
        this.requestRadius = requestRadius;
    }

    protected MSDDataRequestSchema(ReaderBase readerBase) {
        this.clientId = readerBase.getString(KEY_CLIENT_ID, "");
        this.clientPosition = new Position(readerBase.getChild(KEY_CLIENT_POSITION));
        this.requestRadius = readerBase.getLong(KEY_REQUEST_RADIUS, 0L);
    }

    public void updateData(ReaderBase readerBase) {
        readerBase.iterateStringArray(KEY_EXISTING_CATENARY_IDS, () -> this.existingCatenaryIds.clear(), arg_0 -> this.existingCatenaryIds.add(arg_0));
        readerBase.iterateStringArray(KEY_EXISTING_RIGID_CATENARY_IDS, () -> this.existingRigidCatenaryIds.clear(), arg_0 -> this.existingRigidCatenaryIds.add(arg_0));
    }

    public void serializeData(WriterBase writerBase) {
        writerBase.writeString(KEY_CLIENT_ID, this.clientId);
        if (this.clientPosition != null) {
            this.clientPosition.serializeData(writerBase.writeChild(KEY_CLIENT_POSITION));
        }
        writerBase.writeLong(KEY_REQUEST_RADIUS, this.requestRadius);
        this.serializeExistingCatenaryIds(writerBase);
        this.serializeExistingRigidCatenaryIds(writerBase);
    }

    protected void serializeExistingCatenaryIds(WriterBase writerBase) {
        WriterBase.Array existingCatenaryIdsWriterBaseArray = writerBase.writeArray(KEY_EXISTING_CATENARY_IDS);
        this.existingCatenaryIds.forEach(arg_0 -> ((WriterBase.Array)existingCatenaryIdsWriterBaseArray).writeString(arg_0));
    }

    protected void serializeExistingRigidCatenaryIds(WriterBase writerBase) {
        WriterBase.Array existingRigidCatenaryIdsWriterBaseArray = writerBase.writeArray(KEY_EXISTING_RIGID_CATENARY_IDS);
        this.existingRigidCatenaryIds.forEach(arg_0 -> ((WriterBase.Array)existingRigidCatenaryIdsWriterBaseArray).writeString(arg_0));
    }
}

