/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.core.operation;

import javax.annotation.Nullable;
import org.mtr.core.data.Position;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.serializer.SerializedDataBase;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.com.google.gson.JsonObject;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArraySet;
import top.mcmtr.core.data.Catenary;
import top.mcmtr.core.data.RigidCatenary;
import top.mcmtr.core.generated.operation.MSDDeleteDataRequestSchema;
import top.mcmtr.core.operation.MSDDeleteDataResponse;
import top.mcmtr.core.simulation.MSDSimulator;

public final class MSDDeleteDataRequest
extends MSDDeleteDataRequestSchema {
    public MSDDeleteDataRequest() {
    }

    public MSDDeleteDataRequest(ReaderBase readerBase) {
        super(readerBase);
        this.updateData(readerBase);
    }

    public MSDDeleteDataRequest addCatenaryId(String catenaryId) {
        this.catenaryIds.add((Object)catenaryId);
        return this;
    }

    public MSDDeleteDataRequest addCatenaryNodePosition(Position position) {
        this.catenaryNodePositions.add((Object)position);
        return this;
    }

    public MSDDeleteDataRequest addRigidCatenaryId(String catenaryId) {
        this.rigidCatenaryIds.add((Object)catenaryId);
        return this;
    }

    public JsonObject delete(MSDSimulator simulator) {
        MSDDeleteDataResponse deleteDataResponse = new MSDDeleteDataResponse();
        ObjectArraySet nodePositionsToUpdate = new ObjectArraySet();
        this.catenaryIds.forEach(catenaryId -> MSDDeleteDataRequest.delete((Catenary)((Object)((Object)simulator.catenaryIdMap.get(catenaryId))), (ObjectArraySet<Catenary>)simulator.catenaries, catenaryId, deleteDataResponse.getCatenaryIds(), (ObjectArraySet<Position>)nodePositionsToUpdate));
        this.rigidCatenaryIds.forEach(rigidCatenaryId -> MSDDeleteDataRequest.delete((RigidCatenary)((Object)((Object)simulator.rigidCatenaryIdMap.get(rigidCatenaryId))), (ObjectArraySet<RigidCatenary>)simulator.rigidCatenaries, rigidCatenaryId, deleteDataResponse.getRigidCatenaryIds(), (ObjectArraySet<Position>)nodePositionsToUpdate));
        this.catenaryNodePositions.forEach(catenaryNodePosition -> {
            ((Object2ObjectOpenHashMap)simulator.positionsToCatenary.getOrDefault(catenaryNodePosition, (Object)new Object2ObjectOpenHashMap())).values().forEach(catenary -> MSDDeleteDataRequest.delete(catenary, (ObjectArraySet<Catenary>)simulator.catenaries, catenary.getHexId(), deleteDataResponse.getCatenaryIds(), (ObjectArraySet<Position>)nodePositionsToUpdate));
            ((Object2ObjectOpenHashMap)simulator.positionsToRigidCatenary.getOrDefault(catenaryNodePosition, (Object)new Object2ObjectOpenHashMap())).values().forEach(rigidCatenary -> MSDDeleteDataRequest.delete(rigidCatenary, (ObjectArraySet<RigidCatenary>)simulator.rigidCatenaries, rigidCatenary.getHexId(), deleteDataResponse.getRigidCatenaryIds(), (ObjectArraySet<Position>)nodePositionsToUpdate));
        });
        simulator.sync();
        nodePositionsToUpdate.forEach(nodePosition -> {
            if (((Object2ObjectOpenHashMap)simulator.positionsToCatenary.getOrDefault(nodePosition, (Object)new Object2ObjectOpenHashMap())).isEmpty() && ((Object2ObjectOpenHashMap)simulator.positionsToRigidCatenary.getOrDefault(nodePosition, (Object)new Object2ObjectOpenHashMap())).isEmpty()) {
                deleteDataResponse.getCatenaryNodePositions().add(nodePosition);
            }
        });
        return Utilities.getJsonObjectFromData((SerializedDataBase)deleteDataResponse);
    }

    private static void delete(@Nullable Catenary catenary, ObjectArraySet<Catenary> catenaries, String catenaryId, ObjectArrayList<String> catenariesIdsToUpdate, ObjectArraySet<Position> catenaryNodePositionsToUpdate) {
        if (catenary != null) {
            catenaries.remove((Object)catenary);
            catenariesIdsToUpdate.add((Object)catenaryId);
            catenary.writePositions(catenaryNodePositionsToUpdate);
        }
    }

    private static void delete(@Nullable RigidCatenary rigidCatenary, ObjectArraySet<RigidCatenary> rigidCatenaries, String rigidCatenaryId, ObjectArrayList<String> rigidCatenariesIdsToUpdate, ObjectArraySet<Position> rigidCatenaryNodePositionsToUpdate) {
        if (rigidCatenary != null) {
            rigidCatenaries.remove((Object)rigidCatenary);
            rigidCatenariesIdsToUpdate.add((Object)rigidCatenaryId);
            rigidCatenary.writePositions(rigidCatenaryNodePositionsToUpdate);
        }
    }
}

