/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.mod.blocks;

import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.BlockWithEntity;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.IBlock;
import top.mcmtr.mod.Init;
import top.mcmtr.mod.blocks.BlockChangeModelBase;
import top.mcmtr.mod.config.Config;
import top.mcmtr.mod.packet.MSDPacketOpenCustomScreen;

public abstract class BlockCustomTextBase
extends BlockChangeModelBase
implements DirectionHelper,
BlockWithEntity {
    private final int maxArrivals;

    public BlockCustomTextBase(BlockSettings blockSettings, int maxArrivals, int maxModelNum) {
        super(blockSettings, maxModelNum);
        this.maxArrivals = maxArrivals;
    }

    public int getMaxArrivals() {
        return this.maxArrivals;
    }

    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        return IBlock.checkHoldingBrush((World)world, (PlayerEntity)player, () -> {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity != null && blockEntity.data instanceof BlockCustomTextEntity) {
                Init.REGISTRY.sendPacketToClient(ServerPlayerEntity.cast((HolderBase)player), (PacketHandler)new MSDPacketOpenCustomScreen(pos, this.maxArrivals));
            }
        });
    }

    public static abstract class BlockCustomTextEntity
    extends BlockEntityExtension {
        private final int maxArrivals;
        private final String[] messages;
        private static final String KEY_MESSAGE = "msd_custom_message";

        public BlockCustomTextEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState, int maxArrivals) {
            super(type, blockPos, blockState);
            this.maxArrivals = maxArrivals;
            this.messages = new String[maxArrivals];
        }

        public void readCompoundTag(CompoundTag compoundTag) {
            for (int i = 0; i < this.maxArrivals; ++i) {
                this.messages[i] = compoundTag.getString(KEY_MESSAGE + i);
            }
        }

        public void writeCompoundTag(CompoundTag compoundTag) {
            for (int i = 0; i < this.maxArrivals; ++i) {
                compoundTag.putString(KEY_MESSAGE + i, this.messages[i] == null ? "" : this.messages[i]);
            }
        }

        public void setMessages(String[] messages) {
            System.arraycopy(messages, 0, this.messages, 0, Math.min(messages.length, this.maxArrivals));
            this.markDirty2();
        }

        public String getMessage(int index) {
            if (index >= 0 && index < this.maxArrivals && this.messages[index] != null) {
                return this.messages[index];
            }
            return "";
        }

        public double getRenderDistance2() {
            return Config.getCustomTextSignMaxViewDistance();
        }
    }
}

