/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.mod.blocks;

import java.util.List;
import net.minecraft.world.level.block.state.properties.Property;
import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.VoxelShapes;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.BlockExtension;
import org.mtr.mapping.mapper.BlockHelper;
import org.mtr.mapping.mapper.BlockWithEntity;
import org.mtr.mapping.tool.HolderBase;
import top.mcmtr.core.data.OffsetPosition;

public abstract class BlockNodeBase
extends BlockExtension
implements BlockWithEntity {
    public static final BooleanProperty IS_CONNECTED = BooleanProperty.of((String)"is_connected");

    public BlockNodeBase() {
        super(BlockHelper.createBlockSettings((boolean)true).nonOpaque());
    }

    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add((HolderBase<?>)IS_CONNECTED);
    }

    public BlockState getPlacementState2(ItemPlacementContext ctx) {
        return this.getDefaultState2().with(new org.mtr.mapping.holder.Property((Property)BlockNodeBase.IS_CONNECTED.data), (Comparable)Boolean.valueOf(false));
    }

    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        return VoxelShapes.fullCube();
    }

    public VoxelShape getCollisionShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        return VoxelShapes.empty();
    }

    public static void resetCatenaryNode(ServerWorld serverWorld, BlockPos blockPos) {
        BlockState state = serverWorld.getBlockState(blockPos);
        if (state.getBlock().data instanceof BlockNodeBase) {
            serverWorld.setBlockState(blockPos, state.with(new org.mtr.mapping.holder.Property((Property)BlockNodeBase.IS_CONNECTED.data), (Comparable)Boolean.valueOf(false)));
        }
    }

    public static abstract class BlockNodeBaseEntity
    extends BlockEntityExtension {
        private static final String KEY_OFFSET_POSITION = "msd_offset_position_";
        private final OffsetPosition offsetPosition = new OffsetPosition(0.0, 0.0, 0.0);

        public BlockNodeBaseEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
            super(type, blockPos, blockState);
        }

        public void setOffsetPosition(OffsetPosition offsetPosition) {
            this.offsetPosition.setX(offsetPosition.getX());
            this.offsetPosition.setY(offsetPosition.getY());
            this.offsetPosition.setZ(offsetPosition.getZ());
            this.markDirty2();
        }

        public OffsetPosition getOffsetPosition() {
            return this.offsetPosition;
        }

        public void readCompoundTag(CompoundTag compoundTag) {
            this.offsetPosition.setX(compoundTag.getDouble("msd_offset_position_x"));
            this.offsetPosition.setY(compoundTag.getDouble("msd_offset_position_y"));
            this.offsetPosition.setZ(compoundTag.getDouble("msd_offset_position_z"));
        }

        public void writeCompoundTag(CompoundTag compoundTag) {
            compoundTag.putDouble("msd_offset_position_x", this.offsetPosition.getX());
            compoundTag.putDouble("msd_offset_position_y", this.offsetPosition.getY());
            compoundTag.putDouble("msd_offset_position_z", this.offsetPosition.getZ());
        }
    }
}

