/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.mod.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.com.google.gson.JsonElement;
import org.mtr.libraries.com.google.gson.JsonObject;
import org.mtr.mapping.holder.MinecraftClient;
import top.mcmtr.mod.Init;

public class Config {
    private static int rigidCatenarySegmentLength = 1;
    private static int yuuniPIDSMaxViewDistance = 128;
    private static int yamanoteRailwaySignMaxViewDistance = 128;
    private static int customTextSignMaxViewDistance = 128;
    private static final String SEGMENT_LENGTH = "rigid_catenary_segment_length";
    private static final String PIDS_MAX_VIEW_DISTANCE = "yuuni_pids_max_view_distance";
    private static final String RAILWAY_SIGN_MAX_VIEW_DISTANCE = "railway_sign_max_view_distance";
    private static final String TEXT_SIGN_MAX_VIEW_DISTANCE = "custom_text_sign_max_view_distance";
    private static final Path CONFIG_PATH = MinecraftClient.getInstance().getRunDirectoryMapped().toPath().resolve("config").resolve("msd.json");
    public static final int MAX_VIEW_DISTANCE = 256;

    public static void setRigidCatenarySegmentLength(int rigidCatenarySegmentLength) {
        Config.rigidCatenarySegmentLength = rigidCatenarySegmentLength;
        Config.writeToFile();
    }

    public static void setYuuniPIDSMaxViewDistance(int yuuniPIDSMaxViewDistance) {
        Config.yuuniPIDSMaxViewDistance = yuuniPIDSMaxViewDistance;
        Config.writeToFile();
    }

    public static void setYamanoteRailwaySignMaxViewDistance(int yamanoteRailwaySignMaxViewDistance) {
        Config.yamanoteRailwaySignMaxViewDistance = yamanoteRailwaySignMaxViewDistance;
        Config.writeToFile();
    }

    public static void setCustomTextSignMaxViewDistance(int customTextSignMaxViewDistance) {
        Config.customTextSignMaxViewDistance = customTextSignMaxViewDistance;
        Config.writeToFile();
    }

    public static int getRigidCatenarySegmentLength() {
        return rigidCatenarySegmentLength;
    }

    public static int getYuuniPIDSMaxViewDistance() {
        return yuuniPIDSMaxViewDistance;
    }

    public static int getYamanoteRailwaySignMaxViewDistance() {
        return yamanoteRailwaySignMaxViewDistance;
    }

    public static int getCustomTextSignMaxViewDistance() {
        return customTextSignMaxViewDistance;
    }

    public static void refreshProperties() {
        Init.MSD_LOGGER.info("Refreshed MSD config");
        try {
            JsonObject jsonConfig = Utilities.parseJson((String)String.join((CharSequence)"", Files.readAllLines(CONFIG_PATH))).getAsJsonObject();
            try {
                rigidCatenarySegmentLength = jsonConfig.get(SEGMENT_LENGTH).getAsInt();
                if (rigidCatenarySegmentLength < 1 || rigidCatenarySegmentLength > 4) {
                    Init.MSD_LOGGER.error("error! Rigid Catenary Segment Length must be >= 1 & <= 4");
                    rigidCatenarySegmentLength = 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                yuuniPIDSMaxViewDistance = jsonConfig.get(PIDS_MAX_VIEW_DISTANCE).getAsInt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                yamanoteRailwaySignMaxViewDistance = jsonConfig.get(RAILWAY_SIGN_MAX_VIEW_DISTANCE).getAsInt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                customTextSignMaxViewDistance = jsonConfig.get(TEXT_SIGN_MAX_VIEW_DISTANCE).getAsInt();
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            Config.writeToFile();
            Config.refreshProperties();
        }
    }

    private static void writeToFile() {
        Init.MSD_LOGGER.info("Wrote MSD config to file");
        JsonObject jsonConfig = new JsonObject();
        jsonConfig.addProperty(SEGMENT_LENGTH, (Number)rigidCatenarySegmentLength);
        jsonConfig.addProperty(PIDS_MAX_VIEW_DISTANCE, (Number)yuuniPIDSMaxViewDistance);
        jsonConfig.addProperty(RAILWAY_SIGN_MAX_VIEW_DISTANCE, (Number)yamanoteRailwaySignMaxViewDistance);
        jsonConfig.addProperty(TEXT_SIGN_MAX_VIEW_DISTANCE, (Number)customTextSignMaxViewDistance);
        try {
            if (!Files.exists(CONFIG_PATH.getParent(), new LinkOption[0])) {
                Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            }
            Files.write(CONFIG_PATH, Collections.singleton(Utilities.prettyPrint((JsonElement)jsonConfig)), new OpenOption[0]);
        }
        catch (IOException e) {
            Init.logException(e, "Configuration file write exception");
        }
    }
}

