/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.mod.items;

import javax.annotation.Nullable;
import net.minecraft.world.level.block.state.properties.Property;
import org.mtr.core.data.Position;
import org.mtr.core.data.TwoPositionsBase;
import org.mtr.core.tool.Angle;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.ItemSettings;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.ItemUsageContext;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.tool.HolderBase;
import top.mcmtr.core.data.CatenaryType;
import top.mcmtr.core.data.RigidCatenary;
import top.mcmtr.mod.Init;
import top.mcmtr.mod.blocks.BlockNodeBase;
import top.mcmtr.mod.blocks.BlockRigidCatenaryNode;
import top.mcmtr.mod.items.ItemBlockClickingBase;
import top.mcmtr.mod.packet.MSDPacketDeleteData;
import top.mcmtr.mod.packet.MSDPacketUpdateData;

public final class ItemRigidCatenaryConnector
extends ItemBlockClickingBase {
    public ItemRigidCatenaryConnector(ItemSettings itemSettings, boolean isConnector) {
        super(itemSettings, isConnector, CatenaryType.RIGID_CATENARY);
    }

    @Override
    protected void onConnect(World world, ItemStack stack, BlockState stateStart, BlockState stateEnd, BlockPos posStart, BlockPos posEnd, CatenaryType catenaryType, @Nullable ServerPlayerEntity player) {
        Position positionEnd;
        Position positionStart = Init.blockPosToPosition(posStart);
        if (RigidCatenary.verifyPosition(positionStart, positionEnd = Init.blockPosToPosition(posEnd))) {
            ObjectObjectImmutablePair<Angle, Angle> angles = ItemRigidCatenaryConnector.getAngles(posStart, BlockRigidCatenaryNode.getAngle(stateStart), posEnd, BlockRigidCatenaryNode.getAngle(stateEnd));
            RigidCatenary rigidCatenary = new RigidCatenary(positionStart, (Angle)angles.left(), positionEnd, (Angle)angles.right(), RigidCatenary.Shape.QUADRATIC, 0.0);
            world.setBlockState(posStart, stateStart.with(new org.mtr.mapping.holder.Property((Property)BlockNodeBase.IS_CONNECTED.data), (Comparable)Boolean.valueOf(true)));
            world.setBlockState(posEnd, stateEnd.with(new org.mtr.mapping.holder.Property((Property)BlockNodeBase.IS_CONNECTED.data), (Comparable)Boolean.valueOf(true)));
            MSDPacketUpdateData.sendDirectlyToServerRigidCatenary(ServerWorld.cast((HolderBase)world), rigidCatenary);
        }
    }

    @Override
    protected void onRemove(World world, BlockPos posStart, BlockPos posEnd, @Nullable ServerPlayerEntity player) {
        MSDPacketDeleteData.sendDirectlyToServerRigidCatenaryId(ServerWorld.cast((HolderBase)world), TwoPositionsBase.getHexId((Position)Init.blockPosToPosition(posStart), (Position)Init.blockPosToPosition(posEnd)));
    }

    @Override
    protected boolean clickCondition(ItemUsageContext context) {
        World world = context.getWorld();
        Block blockStart = world.getBlockState(context.getBlockPos()).getBlock();
        return blockStart.data instanceof BlockRigidCatenaryNode;
    }

    public static ObjectObjectImmutablePair<Angle, Angle> getAngles(BlockPos posStart, float angle1, BlockPos posEnd, float angle2) {
        float angleDifference = (float)Math.toDegrees(Math.atan2(posEnd.getZ() - posStart.getZ(), posEnd.getX() - posStart.getX()));
        return new ObjectObjectImmutablePair((Object)Angle.fromAngle((float)(angle1 + (float)(Angle.similarFacing((float)angleDifference, (float)angle1) ? 0 : 180))), (Object)Angle.fromAngle((float)(angle2 + (float)(Angle.similarFacing((float)angleDifference, (float)angle2) ? 180 : 0))));
    }
}

