/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.mod.packet;

import javax.annotation.Nonnull;
import org.mtr.core.data.Position;
import org.mtr.core.integration.Response;
import org.mtr.core.serializer.SerializedDataBase;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.com.google.gson.JsonObject;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.tool.PacketBufferReceiver;
import top.mcmtr.core.operation.MSDDeleteDataRequest;
import top.mcmtr.core.operation.MSDDeleteDataResponse;
import top.mcmtr.mod.Init;
import top.mcmtr.mod.blocks.BlockNodeBase;
import top.mcmtr.mod.client.MSDMinecraftClientData;
import top.mcmtr.mod.packet.MSDPacketRequestResponseBase;

public final class MSDPacketDeleteData
extends MSDPacketRequestResponseBase {
    public MSDPacketDeleteData(PacketBufferReceiver packetBufferReceiver) {
        super(packetBufferReceiver);
    }

    public MSDPacketDeleteData(MSDDeleteDataRequest deleteDataRequest) {
        super(Utilities.getJsonObjectFromData((SerializedDataBase)deleteDataRequest).toString());
    }

    public MSDPacketDeleteData(String content) {
        super(content);
    }

    @Override
    protected void runServerInbound(ServerWorld serverWorld, String content) {
        ((MSDDeleteDataResponse)Response.create((JsonObject)Utilities.parseJson((String)content)).getData(MSDDeleteDataResponse::new)).iterateCatenaryNodePosition(catenaryNodePosition -> BlockNodeBase.resetCatenaryNode(serverWorld, Init.positionToBlockPos(catenaryNodePosition)));
    }

    @Override
    protected void runClientInbound(Response response) {
        MSDDeleteDataResponse deleteDataResponse = (MSDDeleteDataResponse)response.getData(MSDDeleteDataResponse::new);
        deleteDataResponse.write(MSDMinecraftClientData.getInstance());
    }

    @Override
    protected MSDPacketRequestResponseBase getInstance(String content) {
        return new MSDPacketDeleteData(content);
    }

    @Override
    @Nonnull
    protected String getEndpoint() {
        return "operation/delete-data";
    }

    @Override
    protected MSDPacketRequestResponseBase.ResponseType responseType() {
        return MSDPacketRequestResponseBase.ResponseType.ALL;
    }

    public static void sendDirectlyToServerCatenaryNodePosition(ServerWorld serverWorld, Position catenaryNodePosition) {
        new MSDPacketDeleteData(new MSDDeleteDataRequest().addCatenaryNodePosition(catenaryNodePosition)).runServerOutbound(serverWorld, null);
    }

    public static void sendDirectlyToServerCatenaryId(ServerWorld serverWorld, String catenaryId) {
        new MSDPacketDeleteData(new MSDDeleteDataRequest().addCatenaryId(catenaryId)).runServerOutbound(serverWorld, null);
    }

    public static void sendDirectlyToServerRigidCatenaryId(ServerWorld serverWorld, String rigidCatenaryId) {
        new MSDPacketDeleteData(new MSDDeleteDataRequest().addRigidCatenaryId(rigidCatenaryId)).runServerOutbound(serverWorld, null);
    }
}

