/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.mod.packet;

import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;
import top.mcmtr.mod.blocks.BlockCustomTextBase;

public class MSDPacketUpdateCustomText
extends PacketHandler {
    private final BlockPos blockPos;
    private final String[] messages;

    public MSDPacketUpdateCustomText(PacketBufferReceiver packetBufferReceiver) {
        this.blockPos = BlockPos.fromLong((long)packetBufferReceiver.readLong());
        int length = packetBufferReceiver.readInt();
        this.messages = new String[length];
        for (int i = 0; i < length; ++i) {
            this.messages[i] = packetBufferReceiver.readString();
        }
    }

    public MSDPacketUpdateCustomText(BlockPos blockPos, String[] messages) {
        this.blockPos = blockPos;
        this.messages = messages;
    }

    public void write(PacketBufferSender packetBufferSender) {
        packetBufferSender.writeLong(this.blockPos.asLong());
        packetBufferSender.writeInt(this.messages.length);
        for (String message : this.messages) {
            packetBufferSender.writeString(message == null ? "" : message);
        }
    }

    public void runServer(MinecraftServer minecraftServer, ServerPlayerEntity serverPlayerEntity) {
        BlockEntity entity = serverPlayerEntity.getEntityWorld().getBlockEntity(this.blockPos);
        if (entity != null && entity.data instanceof BlockCustomTextBase.BlockCustomTextEntity) {
            ((BlockCustomTextBase.BlockCustomTextEntity)((Object)entity.data)).setMessages(this.messages);
        }
    }
}

