/*
 * Decompiled with CFR 0.152.
 */
package de.nekeras.borderless.client;

import com.mojang.blaze3d.platform.Monitor;
import com.mojang.blaze3d.platform.Window;
import de.nekeras.borderless.client.GlfwWindowAttribute;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.glfw.GLFW;

@OnlyIn(value=Dist.CLIENT)
public final class GlfwUtils {
    private static final Logger log = LogManager.getLogger();

    private GlfwUtils() {
    }

    @Nonnull
    public static String getMonitorName(@Nonnull Monitor monitor) {
        String name = GLFW.glfwGetMonitorName((long)monitor.m_84954_());
        if (name == null) {
            log.warn("Could not retrieve monitor name for {}", (Object)monitor.m_84954_());
            return "- ERROR -";
        }
        return name;
    }

    @Nonnull
    public static Optional<Monitor> tryGetMonitor(@Nonnull Window window) {
        Monitor monitor = window.m_85450_();
        if (monitor == null) {
            log.error("Window's current monitor could not be retrieved");
        }
        return Optional.ofNullable(monitor);
    }

    public static void enableWindowAttribute(@Nonnull Window window, @Nonnull GlfwWindowAttribute attribute) {
        log.info("Enable window attribute {}", (Object)attribute.name());
        GLFW.glfwSetWindowAttrib((long)window.m_85439_(), (int)attribute.getBit(), (int)1);
    }

    public static void disableWindowAttribute(@Nonnull Window window, @Nonnull GlfwWindowAttribute attribute) {
        log.info("Disable window attribute {}", (Object)attribute.name());
        GLFW.glfwSetWindowAttrib((long)window.m_85439_(), (int)attribute.getBit(), (int)0);
    }

    public static void applyDefaultWindowAttributes(@Nonnull Window window) {
        log.info("Resetting window attributes");
        for (GlfwWindowAttribute attribute : GlfwWindowAttribute.values()) {
            if (attribute.isEnabledByDefault()) {
                GlfwUtils.enableWindowAttribute(window, attribute);
                continue;
            }
            GlfwUtils.disableWindowAttribute(window, attribute);
        }
        log.info("Done resetting window attributes");
    }

    public static void checkInputMode(@Nonnull Window window) {
        log.info("Checking window input mode");
        switch (GLFW.glfwGetInputMode((long)window.m_85439_(), (int)208897)) {
            case 212993: {
                log.info("Detected normal cursor mode");
                break;
            }
            case 212994: {
                log.info("Detected hidden cursor mode");
                GLFW.glfwSetInputMode((long)window.m_85439_(), (int)208897, (int)212993);
                break;
            }
            case 212995: {
                log.info("Detected disabled cursor mode");
                break;
            }
            default: {
                log.info("Unknown cursor mode");
            }
        }
        log.info("Done checking window input mode");
        double[] xPos = new double[1];
        double[] yPos = new double[1];
        GLFW.glfwGetCursorPos((long)window.m_85439_(), (double[])xPos, (double[])yPos);
        int x = (int)Math.floor(xPos[0]);
        int y = (int)Math.floor(yPos[0]);
        int winWidth = window.m_85441_();
        int winHeight = window.m_85442_();
        boolean inside = x >= 0 && x <= winWidth && y >= 0 && y <= winHeight;
        log.info("Cursor is at {}x{} (inside window: {})", (Object)x, (Object)y, (Object)inside);
        log.info("Done checking cursor position");
    }
}

