/*
 * Decompiled with CFR 0.152.
 */
package de.nekeras.borderless.client.fullscreen;

import com.mojang.blaze3d.platform.Monitor;
import com.mojang.blaze3d.platform.VideoMode;
import com.mojang.blaze3d.platform.Window;
import de.nekeras.borderless.client.GlfwUtils;
import de.nekeras.borderless.client.GlfwWindowAttribute;
import de.nekeras.borderless.client.fullscreen.FullscreenDisplayMode;
import javax.annotation.Nonnull;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.glfw.GLFW;

@OnlyIn(value=Dist.CLIENT)
public class NativeWindowedFullscreenDisplay
implements FullscreenDisplayMode {
    private static final Logger log = LogManager.getLogger();

    @Override
    public void apply(@Nonnull Window window) {
        FullscreenDisplayMode.super.apply(window);
        GlfwUtils.disableWindowAttribute(window, GlfwWindowAttribute.AUTO_ICONIFY);
        GLFW.glfwSetWindowAttrib((long)window.m_85439_(), (int)131078, (int)0);
        GLFW.glfwSetWindowFocusCallback((long)window.m_85439_(), (win, focused) -> {
            if (focused) {
                this.onFocusGained(window);
            } else {
                this.onFocusLost(window);
            }
        });
    }

    @Override
    public void reset(@Nonnull Window window) {
        FullscreenDisplayMode.super.reset(window);
        GLFW.glfwSetWindowFocusCallback((long)window.m_85439_(), null);
    }

    private void onFocusGained(@Nonnull Window window) {
        Monitor monitor = GlfwUtils.tryGetMonitor(window).orElse(null);
        if (monitor == null) {
            log.error("Could not find monitor for window");
        } else {
            VideoMode videoMode = window.m_85436_().orElseGet(() -> ((Monitor)monitor).m_84950_());
            GLFW.glfwSetWindowMonitor((long)window.m_85439_(), (long)monitor.m_84954_(), (int)0, (int)0, (int)videoMode.m_85332_(), (int)videoMode.m_85335_(), (int)videoMode.m_85341_());
        }
    }

    private void onFocusLost(@Nonnull Window window) {
        GLFW.glfwSetWindowMonitor((long)window.m_85439_(), (long)0L, (int)window.m_85447_(), (int)window.m_85448_(), (int)window.m_85441_(), (int)window.m_85442_(), (int)-1);
    }
}

