/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked_programs.cccbridge.entity.animatronic;

import cc.tweaked_programs.cccbridge.Misc;
import cc.tweaked_programs.cccbridge.entity.animatronic.AnimatronicRenderer;
import java.util.Optional;
import net.minecraft.core.Rotations;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class AnimatronicEntity
extends Entity {
    private static final Rotations DEFAULT_HEAD_POSE = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_BODY_POSE = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_LEFT_ARM_POSE = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_RIGHT_ARM_POSE = new Rotations(0.0f, 0.0f, 0.0f);
    public static final EntityDataAccessor<Rotations> DATA_HEAD_POSE = SynchedEntityData.m_135353_(AnimatronicEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135037_);
    public static final EntityDataAccessor<Rotations> DATA_BODY_POSE = SynchedEntityData.m_135353_(AnimatronicEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135037_);
    public static final EntityDataAccessor<Rotations> DATA_LEFT_ARM_POSE = SynchedEntityData.m_135353_(AnimatronicEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135037_);
    public static final EntityDataAccessor<Rotations> DATA_RIGHT_ARM_POSE = SynchedEntityData.m_135353_(AnimatronicEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135037_);
    public static final EntityDataAccessor<String> DATA_FACE = SynchedEntityData.m_135353_(AnimatronicEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private Rotations headPose = new Rotations(DEFAULT_HEAD_POSE.m_123156_(), DEFAULT_HEAD_POSE.m_123157_(), DEFAULT_HEAD_POSE.m_123158_());
    private Rotations bodyPose = new Rotations(DEFAULT_BODY_POSE.m_123156_(), DEFAULT_BODY_POSE.m_123157_(), DEFAULT_BODY_POSE.m_123158_());
    private Rotations leftArmPose = new Rotations(DEFAULT_LEFT_ARM_POSE.m_123156_(), DEFAULT_LEFT_ARM_POSE.m_123157_(), DEFAULT_LEFT_ARM_POSE.m_123158_());
    private Rotations rightArmPose = new Rotations(DEFAULT_RIGHT_ARM_POSE.m_123156_(), DEFAULT_RIGHT_ARM_POSE.m_123157_(), DEFAULT_RIGHT_ARM_POSE.m_123158_());
    private Rotations current_headPose = new Rotations(DEFAULT_HEAD_POSE.m_123156_(), DEFAULT_HEAD_POSE.m_123157_(), DEFAULT_HEAD_POSE.m_123158_());
    private Rotations current_bodyPose = new Rotations(DEFAULT_BODY_POSE.m_123156_(), DEFAULT_BODY_POSE.m_123157_(), DEFAULT_BODY_POSE.m_123158_());
    private Rotations current_leftArmPose = new Rotations(DEFAULT_LEFT_ARM_POSE.m_123156_(), DEFAULT_LEFT_ARM_POSE.m_123157_(), DEFAULT_LEFT_ARM_POSE.m_123158_());
    private Rotations current_rightArmPose = new Rotations(DEFAULT_RIGHT_ARM_POSE.m_123156_(), DEFAULT_RIGHT_ARM_POSE.m_123157_(), DEFAULT_RIGHT_ARM_POSE.m_123158_());
    private Rotations start_headPose = new Rotations(DEFAULT_HEAD_POSE.m_123156_(), DEFAULT_HEAD_POSE.m_123157_(), DEFAULT_HEAD_POSE.m_123158_());
    private Rotations start_bodyPose = new Rotations(DEFAULT_BODY_POSE.m_123156_(), DEFAULT_BODY_POSE.m_123157_(), DEFAULT_BODY_POSE.m_123158_());
    private Rotations start_leftArmPose = new Rotations(DEFAULT_LEFT_ARM_POSE.m_123156_(), DEFAULT_LEFT_ARM_POSE.m_123157_(), DEFAULT_LEFT_ARM_POSE.m_123158_());
    private Rotations start_rightArmPose = new Rotations(DEFAULT_RIGHT_ARM_POSE.m_123156_(), DEFAULT_RIGHT_ARM_POSE.m_123157_(), DEFAULT_RIGHT_ARM_POSE.m_123158_());
    private boolean isMoving = true;
    private double step = 0.0;
    private long start_animation = 0L;
    private String face = "normal";

    public AnimatronicEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public void updateCurrentPoses(float partialTicks) {
        this.step = (double)((float)(this.f_19853_.m_46467_() - this.start_animation) + partialTicks) * 0.10500000000000001;
        this.current_headPose = this.updatePose(this.start_headPose, this.getDestinationHeadPose());
        this.current_bodyPose = this.updatePose(this.start_bodyPose, this.getDestinationBodyPose());
        this.current_leftArmPose = this.updatePose(this.start_leftArmPose, this.getDestinationLeftArmPose());
        this.current_rightArmPose = this.updatePose(this.start_rightArmPose, this.getDestinationRightArmPose());
        if (this.step >= 1.0) {
            this.isMoving = false;
            this.current_headPose = this.getDestinationHeadPose();
            this.current_bodyPose = this.getDestinationBodyPose();
            this.current_leftArmPose = this.getDestinationLeftArmPose();
            this.current_rightArmPose = this.getDestinationRightArmPose();
        }
    }

    private Rotations updatePose(Rotations start, Rotations destination) {
        float x = Misc.updateMovement(start.m_123156_(), destination.m_123156_(), this.step);
        float y = Misc.updateMovement(start.m_123157_(), destination.m_123157_(), this.step);
        float z = Misc.updateMovement(start.m_123158_(), destination.m_123158_(), this.step);
        return new Rotations(x, y, z);
    }

    public boolean isMoving() {
        return this.isMoving;
    }

    public void startAnimation() {
        if (this.f_19853_ == null) {
            this.current_headPose = this.getDestinationHeadPose();
            this.current_bodyPose = this.getDestinationBodyPose();
            this.current_leftArmPose = this.getDestinationLeftArmPose();
            this.current_rightArmPose = this.getRightArmPose();
            return;
        }
        if (!this.f_19853_.f_46443_) {
            return;
        }
        this.start_animation = this.f_19853_.m_46467_();
        this.start_headPose = this.current_headPose;
        this.start_bodyPose = this.current_bodyPose;
        this.start_leftArmPose = this.current_leftArmPose;
        this.start_rightArmPose = this.current_rightArmPose;
        this.isMoving = true;
        this.step = 0.0;
    }

    public ResourceLocation getFace() {
        if (this.f_19804_.m_135370_(DATA_FACE) == null) {
            return AnimatronicRenderer.TEXTURE_FACE_NORMAL;
        }
        return switch ((String)this.f_19804_.m_135370_(DATA_FACE)) {
            case "normal" -> AnimatronicRenderer.TEXTURE_FACE_NORMAL;
            case "happy" -> AnimatronicRenderer.TEXTURE_FACE_HAPPY;
            case "question" -> AnimatronicRenderer.TEXTURE_FACE_QUESTION;
            case "sad" -> AnimatronicRenderer.TEXTURE_FACE_SAD;
            default -> AnimatronicRenderer.TEXTURE_FACE_NORMAL;
        };
    }

    public void setFace(String face) {
        this.f_19804_.m_135381_(DATA_FACE, (Object)face);
    }

    public void setRightArmPose(Rotations rotations) {
        this.f_19804_.m_135381_(DATA_RIGHT_ARM_POSE, (Object)rotations);
    }

    public void setLeftArmPose(Rotations rotations) {
        this.f_19804_.m_135381_(DATA_LEFT_ARM_POSE, (Object)rotations);
    }

    public void setBodyPose(Rotations rotations) {
        this.f_19804_.m_135381_(DATA_BODY_POSE, (Object)rotations);
    }

    public void forceBodyPose(Rotations rotations) {
        this.setBodyPose(rotations);
        this.current_bodyPose = rotations;
    }

    public void setHeadPose(Rotations rotations) {
        this.f_19804_.m_135381_(DATA_HEAD_POSE, (Object)rotations);
    }

    public Rotations getRightArmPose() {
        return this.current_rightArmPose;
    }

    public Rotations getLeftArmPose() {
        return this.current_leftArmPose;
    }

    public Rotations getBodyPose() {
        return this.current_bodyPose;
    }

    public Rotations getHeadPose() {
        return this.current_headPose;
    }

    public Rotations getDestinationHeadPose() {
        return Optional.ofNullable((Rotations)this.f_19804_.m_135370_(DATA_HEAD_POSE)).orElse(DEFAULT_HEAD_POSE);
    }

    public Rotations getDestinationBodyPose() {
        return Optional.ofNullable((Rotations)this.f_19804_.m_135370_(DATA_BODY_POSE)).orElse(DEFAULT_BODY_POSE);
    }

    public Rotations getDestinationLeftArmPose() {
        return Optional.ofNullable((Rotations)this.f_19804_.m_135370_(DATA_LEFT_ARM_POSE)).orElse(DEFAULT_LEFT_ARM_POSE);
    }

    public Rotations getDestinationRightArmPose() {
        return Optional.ofNullable((Rotations)this.f_19804_.m_135370_(DATA_RIGHT_ARM_POSE)).orElse(DEFAULT_RIGHT_ARM_POSE);
    }

    public void read(CompoundTag nbt) {
        this.m_7378_(nbt);
    }

    public void add(CompoundTag nbt) {
        this.m_7380_(nbt);
    }

    protected void m_7378_(CompoundTag nbt) {
        ListTag ltHead = nbt.m_128437_("headPose", 5);
        this.setHeadPose(ltHead.isEmpty() ? DEFAULT_HEAD_POSE : new Rotations(ltHead));
        ListTag ltBody = nbt.m_128437_("bodyPose", 5);
        this.setBodyPose(ltBody.isEmpty() ? DEFAULT_HEAD_POSE : new Rotations(ltBody));
        ListTag ltLeftArm = nbt.m_128437_("leftArmPose", 5);
        this.setLeftArmPose(ltLeftArm.isEmpty() ? DEFAULT_HEAD_POSE : new Rotations(ltLeftArm));
        ListTag ltArmPose = nbt.m_128437_("rightArmPose", 5);
        this.setRightArmPose(ltArmPose.isEmpty() ? DEFAULT_HEAD_POSE : new Rotations(ltArmPose));
        this.setFace(nbt.m_128461_("face"));
        this.startAnimation();
    }

    protected void m_7380_(CompoundTag nbt) {
        nbt.m_128365_("headPose", (Tag)this.getDestinationHeadPose().m_123155_());
        nbt.m_128365_("bodyPose", (Tag)this.getDestinationBodyPose().m_123155_());
        nbt.m_128365_("leftArmPose", (Tag)this.getDestinationLeftArmPose().m_123155_());
        nbt.m_128365_("rightArmPose", (Tag)this.getDestinationRightArmPose().m_123155_());
        if (this.f_19804_.m_135370_(DATA_FACE) != null) {
            nbt.m_128359_("face", (String)this.f_19804_.m_135370_(DATA_FACE));
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_HEAD_POSE, (Object)this.headPose);
        this.f_19804_.m_135372_(DATA_BODY_POSE, (Object)this.bodyPose);
        this.f_19804_.m_135372_(DATA_LEFT_ARM_POSE, (Object)this.leftArmPose);
        this.f_19804_.m_135372_(DATA_RIGHT_ARM_POSE, (Object)this.rightArmPose);
        this.f_19804_.m_135372_(DATA_FACE, (Object)this.face);
    }

    @NotNull
    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        this.startAnimation();
    }
}

