/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.client.renderer;

import biomesoplenty.common.entity.BoatBOP;
import biomesoplenty.common.entity.ChestBoatBOP;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;

public class BoatRendererBOP
extends BoatRenderer {
    private final Map<BoatBOP.ModelType, Pair<ResourceLocation, BoatModel>> boatResources = (Map)Stream.of(BoatBOP.ModelType.values()).collect(ImmutableMap.toImmutableMap(key -> key, model -> Pair.of((Object)new ResourceLocation("biomesoplenty", BoatRendererBOP.getTextureLocation(model, hasChest)), (Object)this.createBoatModel(context, (BoatBOP.ModelType)((Object)model), hasChest))));

    public BoatRendererBOP(EntityRendererProvider.Context context, boolean hasChest) {
        super(context, false);
    }

    public Pair<ResourceLocation, BoatModel> getModelWithLocation(Boat boat) {
        if (boat instanceof ChestBoatBOP) {
            return this.boatResources.get((Object)((ChestBoatBOP)boat).getModel());
        }
        return this.boatResources.get((Object)((BoatBOP)boat).getModel());
    }

    private static String getTextureLocation(BoatBOP.ModelType model, boolean hasChest) {
        return hasChest ? "textures/entity/chest_boat/" + model.getName() + ".png" : "textures/entity/boat/" + model.getName() + ".png";
    }

    private static ModelLayerLocation createLocation(String name, String layer) {
        return new ModelLayerLocation(new ResourceLocation("biomesoplenty", name), layer);
    }

    public static ModelLayerLocation createBoatModelName(BoatBOP.ModelType model) {
        return BoatRendererBOP.createLocation("boat/" + model.getName(), "main");
    }

    public static ModelLayerLocation createChestBoatModelName(BoatBOP.ModelType model) {
        return BoatRendererBOP.createLocation("chest_boat/" + model.getName(), "main");
    }

    private BoatModel createBoatModel(EntityRendererProvider.Context context, BoatBOP.ModelType model, boolean hasChest) {
        ModelLayerLocation modellayerlocation = hasChest ? BoatRendererBOP.createChestBoatModelName(model) : BoatRendererBOP.createBoatModelName(model);
        return new BoatModel(context.m_174023_(modellayerlocation), hasChest);
    }
}

