/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.block.entity;

import com.lx862.jcm.mod.block.entity.JCMBlockEntityBase;
import com.lx862.jcm.mod.data.JCMServerStats;
import com.lx862.jcm.mod.registry.BlockEntities;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Box;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.holder.SoundCategory;
import org.mtr.mapping.holder.SoundEvent;
import org.mtr.mapping.holder.Vector3i;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.MinecraftServerHelper;
import org.mtr.mapping.mapper.SoundHelper;
import org.mtr.mapping.tool.HolderBase;

public class SoundLooperBlockEntity
extends JCMBlockEntityBase {
    public static final SoundCategory[] SOURCE_LIST = new SoundCategory[]{SoundCategory.MASTER, SoundCategory.MUSIC, SoundCategory.WEATHER, SoundCategory.AMBIENT, SoundCategory.PLAYERS, SoundCategory.BLOCKS, SoundCategory.VOICE};
    private String soundID = "";
    private BlockPos corner1 = new BlockPos(0, 0, 0);
    private BlockPos corner2 = new BlockPos(0, 0, 0);
    private int repeatTick = 20;
    private float volume = 1.0f;
    private int soundCategory = 0;
    private boolean needRedstone = false;
    private boolean limitRange = false;

    public SoundLooperBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(BlockEntities.SOUND_LOOPER.get(), blockPos, blockState);
    }

    public void readCompoundTag(CompoundTag compoundTag) {
        super.readCompoundTag(compoundTag);
        this.repeatTick = compoundTag.getInt("repeat_tick");
        this.soundID = compoundTag.getString("sound_id");
        this.soundCategory = compoundTag.getInt("sound_category");
        this.volume = compoundTag.getFloat("volume");
        this.needRedstone = compoundTag.getBoolean("need_redstone");
        this.limitRange = compoundTag.getBoolean("limit_range");
        this.corner1 = BlockPos.fromLong((long)compoundTag.getLong("pos_1"));
        this.corner2 = BlockPos.fromLong((long)compoundTag.getLong("pos_2"));
    }

    public void writeCompoundTag(CompoundTag compoundTag) {
        super.writeCompoundTag(compoundTag);
        compoundTag.putInt("repeat_tick", this.repeatTick);
        compoundTag.putString("sound_id", this.soundID);
        compoundTag.putInt("sound_category", this.soundCategory);
        compoundTag.putFloat("volume", this.volume);
        compoundTag.putBoolean("need_redstone", this.needRedstone);
        compoundTag.putBoolean("limit_range", this.limitRange);
        compoundTag.putLong("pos_1", this.corner1.asLong());
        compoundTag.putLong("pos_2", this.corner2.asLong());
    }

    public void blockEntityTick() {
        World world = this.getWorld2();
        if (this.repeatTick > 0 && !this.soundID.isEmpty() && world != null && !world.isClient() && JCMServerStats.getGameTick() % this.repeatTick == 0) {
            boolean emittingRedstonePower;
            boolean bl1 = world.isEmittingRedstonePower(this.getPos2(), Direction.NORTH);
            boolean bl2 = world.isEmittingRedstonePower(this.getPos2(), Direction.EAST);
            boolean bl3 = world.isEmittingRedstonePower(this.getPos2(), Direction.SOUTH);
            boolean bl4 = world.isEmittingRedstonePower(this.getPos2(), Direction.WEST);
            boolean bl5 = world.isEmittingRedstonePower(this.getPos2(), Direction.UP);
            boolean bl6 = world.isEmittingRedstonePower(this.getPos2(), Direction.DOWN);
            boolean bl = emittingRedstonePower = bl1 || bl2 || bl3 || bl4 || bl5 || bl6;
            if (this.needRedstone && !emittingRedstonePower) {
                return;
            }
            SoundCategory category = SOURCE_LIST[this.soundCategory];
            Identifier identifier = null;
            try {
                identifier = new Identifier(this.soundID);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (identifier == null) {
                return;
            }
            SoundEvent soundEvent = SoundHelper.createSoundEvent((Identifier)identifier);
            if (!this.limitRange) {
                world.playSound((PlayerEntity)null, this.getPos2(), soundEvent, category, this.volume, 1.0f);
            } else {
                BlockPos corner1 = this.getCorner1();
                BlockPos corner2 = this.getCorner2();
                Box limitedRange = new Box((double)corner1.getX(), (double)corner1.getY(), (double)corner1.getZ(), (double)corner2.getX(), (double)corner2.getY(), (double)corner2.getZ());
                MinecraftServerHelper.iteratePlayers((ServerWorld)ServerWorld.cast((HolderBase)world), player -> {
                    if (limitedRange.contains(player.getPos())) {
                        float dist = this.getPos2().getManhattanDistance(new Vector3i((int)player.getPos().getXMapped(), (int)player.getPos().getYMapped(), (int)player.getPos().getZMapped()));
                        float fadeToZeroDist = 16.0f * this.volume;
                        float calculatedVolume = (1.0f - Math.max(0.001f, dist / fadeToZeroDist)) * this.volume;
                        player.playSound(soundEvent, category, calculatedVolume, 1.0f);
                    }
                });
            }
        }
    }

    public String getSoundId() {
        return this.soundID == null ? "" : this.soundID;
    }

    public int getLoopInterval() {
        return this.repeatTick;
    }

    public int getSoundCategory() {
        if (this.soundCategory > SOURCE_LIST.length) {
            this.soundCategory = 0;
        }
        return this.soundCategory;
    }

    public float getSoundVolume() {
        return this.volume;
    }

    public boolean rangeLimited() {
        return this.limitRange;
    }

    public boolean needRedstone() {
        return this.needRedstone;
    }

    public BlockPos getCorner1() {
        return this.corner1;
    }

    public BlockPos getCorner2() {
        return this.corner2;
    }

    public void setData(String soundId, int soundCategory, int interval, float volume, boolean needRedstone, boolean limitRange, BlockPos corner1, BlockPos corner2) {
        this.soundID = soundId;
        this.repeatTick = interval;
        this.soundCategory = soundCategory;
        this.volume = volume;
        this.needRedstone = needRedstone;
        this.corner1 = corner1;
        this.corner2 = corner2;
        this.limitRange = limitRange;
        this.markDirty2();
    }
}

