/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.config;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.lx862.jcm.mod.util.JCMLogger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;

public abstract class Config {
    private Path configPath;

    public Config(Path configPath) {
        this.configPath = configPath;
    }

    public final void read() {
        if (!Files.exists(this.configPath, new LinkOption[0])) {
            this.write();
            this.read();
        } else {
            try {
                JsonObject jsonObject = new JsonParser().parse(String.join((CharSequence)"", Files.readAllLines(this.configPath))).getAsJsonObject();
                this.fromJson(jsonObject);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.write();
                JCMLogger.warn("Failed to read config file, config may be left at it's default state.", new Object[0]);
            }
        }
    }

    public final void write() {
        try {
            this.configPath.getParent().toFile().mkdirs();
            Files.write(this.configPath, Collections.singleton(new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)this.toJson())), new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void reset() {
        this.fromJson(new JsonObject());
        this.write();
    }

    protected abstract void fromJson(JsonObject var1);

    protected abstract JsonObject toJson();
}

