/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.data.pids.preset;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.lx862.jcm.mod.JCMClient;
import com.lx862.jcm.mod.block.entity.PIDSBlockEntity;
import com.lx862.jcm.mod.data.KVPair;
import com.lx862.jcm.mod.data.pids.preset.PIDSContext;
import com.lx862.jcm.mod.data.pids.preset.PIDSPresetBase;
import com.lx862.jcm.mod.data.pids.preset.components.ArrivalDestinationComponent;
import com.lx862.jcm.mod.data.pids.preset.components.ArrivalETAComponent;
import com.lx862.jcm.mod.data.pids.preset.components.ArrivalTextureComponent;
import com.lx862.jcm.mod.data.pids.preset.components.ClockComponent;
import com.lx862.jcm.mod.data.pids.preset.components.CustomTextComponent;
import com.lx862.jcm.mod.data.pids.preset.components.PlatformComponent;
import com.lx862.jcm.mod.data.pids.preset.components.WeatherIconComponent;
import com.lx862.jcm.mod.data.pids.preset.components.base.PIDSComponent;
import com.lx862.jcm.mod.data.pids.preset.components.base.TextComponent;
import com.lx862.jcm.mod.render.RenderHelper;
import com.lx862.jcm.mod.render.text.TextAlignment;
import com.lx862.jcm.mod.render.text.TextOverflowMode;
import com.lx862.jcm.mod.resources.mcmeta.McMetaManager;
import com.lx862.jcm.mod.util.JCMLogger;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.mtr.core.operation.ArrivalResponse;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.RenderLayer;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.GraphicsHolder;

public class JsonPIDSPreset
extends PIDSPresetBase {
    private static final int PIDS_MARGIN = 7;
    private static final float ARRIVAL_TEXT_SCALE = 1.225f;
    private static final int HEADER_HEIGHT = 9;
    private static final String ICON_WEATHER_SUNNY = "jsblock:textures/block/pids/weather_sunny.png";
    private static final String ICON_WEATHER_RAINY = "jsblock:textures/block/pids/weather_rainy.png";
    private static final String ICON_WEATHER_THUNDER = "jsblock:textures/block/pids/weather_thunder.png";
    private static final String TEXTURE_PLATFORM_CIRCLE = "jsblock:textures/block/pids/plat_circle.png";
    private final Identifier background;
    private final String fontId;
    private final TextOverflowMode textOverflowMode;
    private final boolean showClock;
    private final boolean showWeather;
    private final boolean topPadding;
    private final boolean hidePlatform;
    private final int textColor;
    private final boolean[] rowHidden;

    public JsonPIDSPreset(String id, @Nullable String name, @Nullable Identifier background, @Nullable String fontId, TextOverflowMode textOverflowMode, boolean[] rowHidden, boolean showClock, boolean showWeather, boolean topPadding, boolean builtin, boolean hidePlatform, int textColor) {
        super(id, name, builtin);
        this.background = background;
        this.showClock = showClock;
        this.showWeather = showWeather;
        this.textColor = textColor;
        this.fontId = fontId == null ? "mtr:mtr" : fontId;
        this.rowHidden = rowHidden;
        this.topPadding = topPadding;
        this.textOverflowMode = textOverflowMode;
        this.hidePlatform = hidePlatform;
    }

    public static JsonPIDSPreset parse(JsonObject jsonObject) {
        boolean[] rowHidden;
        String id = jsonObject.get("id").getAsString();
        boolean showWeather = jsonObject.has("showWeather") && jsonObject.get("showWeather").getAsBoolean();
        boolean showClock = jsonObject.has("showClock") && jsonObject.get("showClock").getAsBoolean();
        boolean topPadding = !jsonObject.has("topPadding") ? true : jsonObject.get("topPadding").getAsBoolean();
        boolean hidePlatform = jsonObject.has("hidePlatform") && jsonObject.get("hidePlatform").getAsBoolean();
        int textColor = -16777216;
        String name = id;
        String font = null;
        Identifier background = null;
        TextOverflowMode textOverflowMode = TextOverflowMode.STRETCH;
        if (jsonObject.has("color")) {
            textColor = (int)Long.parseLong(jsonObject.get("color").getAsString(), 16);
        }
        if (jsonObject.has("name")) {
            name = jsonObject.get("name").getAsString();
        }
        if (jsonObject.has("fonts")) {
            font = jsonObject.get("fonts").getAsString();
        }
        if (jsonObject.has("textOverflowMode")) {
            textOverflowMode = TextOverflowMode.valueOf(jsonObject.get("textOverflowMode").getAsString());
        }
        if (jsonObject.has("hideRow")) {
            JsonArray arr = jsonObject.getAsJsonArray("hideRow");
            rowHidden = new boolean[arr.size()];
            for (int i = 0; i < arr.size(); ++i) {
                rowHidden[i] = arr.get(i).getAsBoolean();
            }
        } else {
            rowHidden = new boolean[]{};
        }
        if (jsonObject.has("background")) {
            Identifier backgroundId = new Identifier(jsonObject.get("background").getAsString());
            try {
                McMetaManager.load(backgroundId);
            }
            catch (Exception e) {
                e.printStackTrace();
                JCMLogger.warn("Failed to parse mcmeta animation file: " + backgroundId.getPath(), new Object[0]);
            }
            background = backgroundId;
        }
        boolean builtin = jsonObject.has("builtin") && jsonObject.get("builtin").getAsBoolean();
        return new JsonPIDSPreset(id, name, background, font, textOverflowMode, rowHidden, showClock, showWeather, topPadding, builtin, hidePlatform, textColor);
    }

    @Override
    public void render(PIDSBlockEntity be, GraphicsHolder graphicsHolder, World world, BlockPos pos, Direction facing, ObjectArrayList<ArrivalResponse> arrivals, boolean[] rowHidden, float tickDelta, int x, int y, int width, int height) {
        int headerHeight = this.topPadding ? 9 : 0;
        int startX = 7;
        int contentWidth = width - 14;
        int contentHeight = height - headerHeight - 3;
        graphicsHolder.createVertexConsumer(RenderLayer.getText((Identifier)this.getBackground()));
        RenderHelper.drawTexture(graphicsHolder, this.getBackground(), 0.0f, 0.0f, 0.0f, width, height, facing, -1, 0xF000F0);
        if (JCMClient.getConfig().debug && JCMClient.getConfig().debug) {
            this.drawAtlasBackground(graphicsHolder, width, height, facing);
        }
        graphicsHolder.translate((double)startX, 0.0, -0.05);
        List<PIDSComponent> components = this.getComponents(arrivals, be.getCustomMessages(), rowHidden, 0, headerHeight + 4, contentWidth, contentHeight, be.getRowAmount(), be.platformNumberHidden());
        PIDSContext pidsContext = new PIDSContext(world, pos, be.getCustomMessages(), arrivals, tickDelta);
        graphicsHolder.push();
        for (PIDSComponent component : components) {
            graphicsHolder.translate(0.0, 0.0, -0.02);
            graphicsHolder.push();
            component.render(graphicsHolder, null, facing, pidsContext);
            graphicsHolder.pop();
        }
        graphicsHolder.pop();
    }

    @Override
    public List<PIDSComponent> getComponents(ObjectArrayList<ArrivalResponse> arrivals, String[] customMessages, boolean[] rowHidden, int x, int y, int screenWidth, int screenHeight, int rows, boolean hidePlatform) {
        ArrayList<PIDSComponent> components = new ArrayList<PIDSComponent>();
        if (this.showClock) {
            components.add(new ClockComponent(screenWidth, 2.0, screenWidth, 10.0, TextComponent.of(TextAlignment.RIGHT, TextOverflowMode.STRETCH, this.getFont(), -1, 0.9)));
        }
        if (this.showWeather) {
            components.add(new WeatherIconComponent(0.0, 0.0, 9.0, 9.0, new KVPair().with("weatherIconSunny", ICON_WEATHER_SUNNY).with("weatherIconRainy", ICON_WEATHER_RAINY).with("weatherIconThunder", ICON_WEATHER_THUNDER)));
        }
        boolean platformShown = !hidePlatform && !this.hidePlatform;
        int arrivalIndex = 0;
        double rowY = y;
        for (int i = 0; i < rows; ++i) {
            if (customMessages[i] != null && !customMessages[i].isEmpty()) {
                components.add(new CustomTextComponent(x, rowY, 95.55f, 10.0, TextComponent.of(TextAlignment.LEFT, this.textOverflowMode, this.getFont(), this.getTextColor(), 1.225f).with("text", customMessages[i])));
            } else {
                if (arrivalIndex >= arrivals.size()) continue;
                if (!rowHidden[i]) {
                    float destinationMaxWidth = platformShown ? 53.9f : 66.15f;
                    components.add(new ArrivalDestinationComponent(x, rowY, destinationMaxWidth, 10.0, TextComponent.of(TextAlignment.LEFT, this.textOverflowMode, this.getFont(), this.textColor, 1.225f).with("arrivalIndex", arrivalIndex)));
                    if (platformShown) {
                        components.add(new ArrivalTextureComponent(72.275f, rowY, 10.0, 10.0, new KVPair().with("textureId", TEXTURE_PLATFORM_CIRCLE).with("arrivalIndex", arrivalIndex)));
                        components.add(new PlatformComponent(72.275f, rowY, 8.0, 8.0, this.getFont(), -1, 0.85, new KVPair().with("arrivalIndex", arrivalIndex)));
                    }
                    components.add(new ArrivalETAComponent(screenWidth, rowY, 26.95f, 20.0, TextComponent.of(TextAlignment.RIGHT, TextOverflowMode.STRETCH, this.getFont(), this.textColor, 1.225f).with("arrivalIndex", arrivalIndex)));
                    ++arrivalIndex;
                }
            }
            rowY += (double)screenHeight / 4.7 * (double)1.225f;
        }
        return components;
    }

    @Override
    public String getFont() {
        return this.fontId;
    }

    @Override
    @Nonnull
    public Identifier getBackground() {
        return this.background;
    }

    @Override
    public int getTextColor() {
        return 0xFF000000 | this.textColor;
    }

    @Override
    public boolean isRowHidden(int row) {
        return this.rowHidden.length - 1 < row ? false : this.rowHidden[row];
    }
}

