/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.data.pids.preset.components.base;

import com.lx862.jcm.mod.JCMClient;
import com.lx862.jcm.mod.data.JCMClientStats;
import com.lx862.jcm.mod.data.KVPair;
import com.lx862.jcm.mod.data.pids.preset.components.base.PIDSComponent;
import com.lx862.jcm.mod.render.RenderHelper;
import com.lx862.jcm.mod.render.text.TextAlignment;
import com.lx862.jcm.mod.render.text.TextInfo;
import com.lx862.jcm.mod.render.text.TextOverflowMode;
import com.lx862.jcm.mod.render.text.TextRenderingManager;
import com.lx862.jcm.mod.render.text.TextTranslationMode;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;
import org.mtr.mod.data.IGui;

public abstract class TextComponent
extends PIDSComponent {
    public static final int SWITCH_LANG_DURATION = 60;
    protected final TextOverflowMode textOverflowMode;
    protected final TextAlignment textAlignment;
    protected final TextTranslationMode textTranslationMode;
    protected final String font;
    protected final int textColor;
    protected final double scale;

    public TextComponent(double x, double y, double width, double height, KVPair additionalParam) {
        super(x, y, width, height);
        this.font = additionalParam.get("font", "");
        this.textAlignment = TextAlignment.valueOf(additionalParam.get("textAlignment", "LEFT"));
        this.textOverflowMode = TextOverflowMode.valueOf(additionalParam.get("textOverflowMode", "STRETCH"));
        this.textTranslationMode = TextTranslationMode.valueOf(additionalParam.get("textTranslationMode", "CYCLE"));
        this.scale = additionalParam.getDouble("scale", 1.0);
        this.textColor = additionalParam.getColor("color", 0);
    }

    public static KVPair of(TextAlignment textAlignment, TextOverflowMode textOverflowMode, String font, int textColor, double scale) {
        return new KVPair().with("textAlignment", textAlignment.name()).with("textOverflowMode", textOverflowMode.name()).with("font", font).with("color", textColor).with("scale", scale);
    }

    protected void drawText(GraphicsHolder graphicsHolder, GuiDrawing guiDrawing, Direction facing, String text) {
        this.drawText(graphicsHolder, guiDrawing, facing, new TextInfo(this.cycleString(text)));
    }

    protected void drawText(GraphicsHolder graphicsHolder, GuiDrawing guiDrawing, Direction facing, TextInfo text) {
        TextRenderingManager.bind(graphicsHolder);
        TextInfo finalText = text.withColor(this.textColor + -16777216).withFont(this.font).withTextAlignment(this.textAlignment);
        graphicsHolder.push();
        graphicsHolder.translate(this.x, this.y, 0.0);
        graphicsHolder.scale((float)this.scale, (float)this.scale, (float)this.scale);
        double textWidth = TextRenderingManager.getTextWidth(finalText);
        if (this.textOverflowMode == TextOverflowMode.MARQUEE && textWidth > this.width) {
            finalText = finalText.withScrollingText().withMaxWidth((float)this.width);
        } else {
            RenderHelper.scaleToFit(graphicsHolder, textWidth, this.width, this.textOverflowMode == TextOverflowMode.SCALE, 14.0);
        }
        if (guiDrawing != null) {
            if (JCMClient.getConfig().useNewTextRenderer) {
                TextRenderingManager.draw(graphicsHolder, guiDrawing, finalText, this.x, this.y);
            } else {
                TextRenderingManager.draw(graphicsHolder, guiDrawing, finalText, 0.0, 0.0);
            }
        } else {
            TextRenderingManager.draw(graphicsHolder, finalText, facing, 0.0, 0.0);
        }
        graphicsHolder.pop();
    }

    protected String cycleString(String mtrString) {
        String[] split = mtrString.split("\\|");
        if (split.length == 0) {
            return "";
        }
        if (this.textTranslationMode == TextTranslationMode.CYCLE) {
            return split[(int)JCMClientStats.getGameTick() / 60 % split.length];
        }
        if (this.textTranslationMode == TextTranslationMode.MERGE) {
            return mtrString.replace("|", " ");
        }
        if (this.textTranslationMode == TextTranslationMode.CJK) {
            for (String str : split) {
                if (!IGui.isCjk((String)str)) continue;
                return str;
            }
            return "";
        }
        if (this.textTranslationMode == TextTranslationMode.NON_CJK) {
            for (String str : split) {
                if (IGui.isCjk((String)str)) continue;
                return str;
            }
            return "";
        }
        return mtrString;
    }

    protected String cycleString(String ... string) {
        return this.cycleString(String.join((CharSequence)"|", string));
    }
}

