/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.network.block;

import com.lx862.jcm.mod.block.base.JCMBlock;
import com.lx862.jcm.mod.block.entity.ButterflyLightBlockEntity;
import com.lx862.jcm.mod.util.BlockUtil;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;

public class ButterflyLightUpdatePacket
extends PacketHandler {
    private final BlockPos blockPos;
    private final int startBlinkingSeconds;

    public ButterflyLightUpdatePacket(PacketBufferReceiver packetBufferReceiver) {
        this.blockPos = BlockPos.fromLong((long)packetBufferReceiver.readLong());
        this.startBlinkingSeconds = packetBufferReceiver.readInt();
    }

    public ButterflyLightUpdatePacket(BlockPos blockPos, int startBlinkingSeconds) {
        this.blockPos = blockPos;
        this.startBlinkingSeconds = startBlinkingSeconds;
    }

    public void runServer(MinecraftServer minecraftServer, ServerPlayerEntity serverPlayerEntity) {
        World world = serverPlayerEntity.getEntityWorld();
        BlockState state = BlockUtil.getBlockState(world, this.blockPos);
        if (state == null || !(state.getBlock().data instanceof JCMBlock)) {
            return;
        }
        ((JCMBlock)((Object)state.getBlock().data)).forEachBlockEntity(state, world, this.blockPos, be -> {
            if (be.data instanceof ButterflyLightBlockEntity) {
                ((ButterflyLightBlockEntity)((Object)((Object)be.data))).setData(this.startBlinkingSeconds);
            }
        });
    }

    public void write(PacketBufferSender packetBufferSender) {
        packetBufferSender.writeLong(this.blockPos.asLong());
        packetBufferSender.writeInt(this.startBlinkingSeconds);
    }
}

