/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.render.gui.screen;

import com.lx862.jcm.mod.JCMClient;
import com.lx862.jcm.mod.render.GuiHelper;
import com.lx862.jcm.mod.render.gui.screen.PIDSDemoScreen;
import com.lx862.jcm.mod.render.gui.screen.TextureTextAtlasScreen;
import com.lx862.jcm.mod.render.gui.screen.base.TitledScreen;
import com.lx862.jcm.mod.render.gui.widget.ListViewWidget;
import com.lx862.jcm.mod.render.gui.widget.MappedWidget;
import com.lx862.jcm.mod.render.gui.widget.WidgetSet;
import com.lx862.jcm.mod.util.JCMLogger;
import com.lx862.jcm.mod.util.TextCategory;
import com.lx862.jcm.mod.util.TextUtil;
import java.io.File;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.Util;
import org.mtr.mapping.mapper.ButtonWidgetExtension;
import org.mtr.mapping.mapper.CheckboxWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;

public class ClientConfigScreen
extends TitledScreen
implements GuiHelper {
    private static final Identifier TEXTURE_BACKGROUND = new Identifier("jsblock:textures/gui/config_screen/bg.png");
    private static final Identifier TEXTURE_STAR = new Identifier("jsblock:textures/gui/config_screen/stars.png");
    private static final Identifier TEXTURE_TERRAIN = new Identifier("jsblock:textures/gui/config_screen/terrain.png");
    private final WidgetSet bottomRowWidget;
    private final ListViewWidget listViewWidget;
    private boolean discardConfig = false;
    CheckboxWidgetExtension disableRenderingButton = new CheckboxWidgetExtension(0, 0, 20, 20, false, bool -> {
        JCMClient.getConfig().disableRendering = bool;
    });
    CheckboxWidgetExtension useCustomFontButton = new CheckboxWidgetExtension(0, 0, 20, 20, false, bool -> {
        JCMClient.getConfig().useCustomFont = bool;
    });
    CheckboxWidgetExtension useNewTextRendererButton = new CheckboxWidgetExtension(0, 0, 20, 20, false, bool -> {
        JCMClient.getConfig().useNewTextRenderer = bool;
    });
    CheckboxWidgetExtension debugModeButton = new CheckboxWidgetExtension(0, 0, 20, 20, false, bool -> {
        JCMClient.getConfig().debug = bool;
    });
    ButtonWidgetExtension textAtlasButton = new ButtonWidgetExtension(0, 0, 60, 20, TextUtil.translatable(TextCategory.GUI, "config.listview.widget.open", new Object[0]), buttonWidget -> MinecraftClient.getInstance().openScreen(new org.mtr.mapping.holder.Screen((Screen)new TextureTextAtlasScreen().withPreviousScreen(new org.mtr.mapping.holder.Screen((Screen)this)))));
    ButtonWidgetExtension pidsPreviewButton = new ButtonWidgetExtension(0, 0, 60, 20, TextUtil.translatable(TextCategory.GUI, "config.listview.widget.open", new Object[0]), buttonWidget -> MinecraftClient.getInstance().openScreen(new org.mtr.mapping.holder.Screen((Screen)new PIDSDemoScreen().withPreviousScreen(new org.mtr.mapping.holder.Screen((Screen)this)))));

    public ClientConfigScreen() {
        super(true);
        this.bottomRowWidget = new WidgetSet(20);
        this.listViewWidget = new ListViewWidget();
    }

    @Override
    public MutableText getScreenTitle() {
        return TextUtil.translatable(TextCategory.GUI, "brand", new Object[0]);
    }

    @Override
    public MutableText getScreenSubtitle() {
        return TextUtil.translatable(TextCategory.GUI, "config.version", "2.0.0 Beta-2");
    }

    protected void init2() {
        super.init2();
        this.listViewWidget.reset();
        this.bottomRowWidget.reset();
        int contentWidth = (int)Math.min((double)this.f_96543_ * 0.75, 400.0);
        int listViewHeight = (int)((double)(this.f_96544_ - 60) * 0.75);
        int startX = (this.f_96543_ - contentWidth) / 2;
        int startY = 50;
        int bottomEntryHeight = this.f_96544_ - startY - listViewHeight - 12;
        this.addConfigEntries();
        this.addBottomButtons();
        this.addChild(new ClickableWidget((AbstractWidget)this.listViewWidget));
        this.addChild(new ClickableWidget((AbstractWidget)this.bottomRowWidget));
        this.listViewWidget.setXYSize(startX, startY, contentWidth, listViewHeight);
        this.bottomRowWidget.setXYSize(startX, startY + listViewHeight + 6, contentWidth, bottomEntryHeight);
    }

    private void setEntryStateFromClientConfig() {
        this.disableRenderingButton.setChecked(JCMClient.getConfig().disableRendering);
        this.useCustomFontButton.setChecked(JCMClient.getConfig().useCustomFont);
        this.useNewTextRendererButton.setChecked(JCMClient.getConfig().useNewTextRenderer);
        this.debugModeButton.setChecked(JCMClient.getConfig().debug);
    }

    private void addConfigEntries() {
        this.setEntryStateFromClientConfig();
        this.listViewWidget.addCategory(TextUtil.translatable(TextCategory.GUI, "config.listview.category.general", new Object[0]));
        this.listViewWidget.add(TextUtil.translatable(TextCategory.GUI, "config.listview.title.disable_rendering", new Object[0]), new MappedWidget(this.disableRenderingButton));
        this.addChild(new ClickableWidget((AbstractWidget)this.disableRenderingButton));
        this.listViewWidget.add(TextUtil.translatable(TextCategory.GUI, "config.listview.title.custom_font", new Object[0]), new MappedWidget(this.useCustomFontButton));
        this.addChild(new ClickableWidget((AbstractWidget)this.useCustomFontButton));
        if (JCMClient.getConfig().useNewTextRenderer) {
            this.listViewWidget.addCategory(TextUtil.translatable(TextCategory.GUI, "config.listview.category.experimental", new Object[0]));
            this.listViewWidget.add(TextUtil.translatable(TextCategory.GUI, "config.listview.title.new_text_rendering", new Object[0]), new MappedWidget(this.useNewTextRendererButton));
            this.addChild(new ClickableWidget((AbstractWidget)this.useNewTextRendererButton));
        }
        this.listViewWidget.addCategory(TextUtil.translatable(TextCategory.GUI, "config.listview.category.debug", new Object[0]));
        this.listViewWidget.add(TextUtil.translatable(TextCategory.GUI, "config.listview.title.debug_mode", new Object[0]), new MappedWidget(this.debugModeButton));
        this.addChild(new ClickableWidget((AbstractWidget)this.debugModeButton));
        if (JCMClient.getConfig().useNewTextRenderer) {
            this.listViewWidget.add(TextUtil.translatable(TextCategory.GUI, "config.listview.title.open_atlas_screen", new Object[0]), new MappedWidget(this.textAtlasButton));
            this.addChild(new ClickableWidget((AbstractWidget)this.textAtlasButton));
        }
        this.pidsPreviewButton.setActiveMapped(MinecraftClient.getInstance().getWorldMapped() != null);
    }

    private void addBottomButtons() {
        ButtonWidgetExtension latestLogButton = new ButtonWidgetExtension(0, 0, 0, 20, TextUtil.translatable(TextCategory.GUI, "config.latest_log", new Object[0]), btn -> ClientConfigScreen.openLatestLog());
        ButtonWidgetExtension crashLogButton = new ButtonWidgetExtension(0, 0, 0, 20, TextUtil.translatable(TextCategory.GUI, "config.crash_log", new Object[0]), btn -> ClientConfigScreen.openLatestCrashReport());
        ButtonWidgetExtension saveButton = new ButtonWidgetExtension(0, 0, 0, 20, TextUtil.translatable(TextCategory.GUI, "config.save", new Object[0]), btn -> this.onClose2());
        ButtonWidgetExtension discardButton = new ButtonWidgetExtension(0, 0, 0, 20, TextUtil.translatable(TextCategory.GUI, "config.discard", new Object[0]), btn -> {
            this.discardConfig = true;
            this.onClose2();
        });
        ButtonWidgetExtension resetButton = new ButtonWidgetExtension(0, 0, 0, 20, TextUtil.translatable(TextCategory.GUI, "config.reset", new Object[0]), btn -> {
            JCMClient.getConfig().reset();
            this.setEntryStateFromClientConfig();
        });
        this.addChild(new ClickableWidget((AbstractWidget)latestLogButton));
        this.addChild(new ClickableWidget((AbstractWidget)crashLogButton));
        this.addChild(new ClickableWidget((AbstractWidget)saveButton));
        this.addChild(new ClickableWidget((AbstractWidget)discardButton));
        this.addChild(new ClickableWidget((AbstractWidget)resetButton));
        this.bottomRowWidget.addWidget(latestLogButton);
        this.bottomRowWidget.addWidget(crashLogButton);
        this.bottomRowWidget.insertRow();
        this.bottomRowWidget.addWidget(saveButton);
        this.bottomRowWidget.addWidget(discardButton);
        this.bottomRowWidget.addWidget(resetButton);
    }

    @Override
    public void drawBackground(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float tickDelta) {
        double terrainHeight = (double)this.f_96543_ / 3.75;
        double starSize = Math.max(this.f_96543_, this.f_96544_);
        float starUVSize = (float)(starSize / 384.0);
        double translateY = (double)this.f_96544_ * (1.0 - this.animationProgress);
        GuiDrawing guiDrawing = new GuiDrawing(graphicsHolder);
        GuiHelper.drawTexture(guiDrawing, TEXTURE_BACKGROUND, 0.0, 0.0, this.f_96543_, this.f_96544_);
        GuiHelper.drawTexture(guiDrawing, TEXTURE_STAR, 0.0, translateY * 0.2, starSize, starSize, 0.0f, 0.0f, starUVSize, starUVSize);
        GuiHelper.drawTexture(guiDrawing, TEXTURE_TERRAIN, 0.0, translateY + (double)this.f_96544_ - terrainHeight, this.f_96543_, terrainHeight);
    }

    private void drawPride(GraphicsHolder graphicsHolder) {
        graphicsHolder.push();
        graphicsHolder.rotateYDegrees(5.0f);
        graphicsHolder.scale((float)this.animationProgress, 1.0f, 1.0f);
        double prideAnimationProgress = this.closing ? 1.0 : this.animationProgress;
        int startY = this.f_96544_ / 2;
        int h = this.f_96544_ / 46;
        GuiDrawing guiDrawing = new GuiDrawing(graphicsHolder);
        GuiHelper.drawRectangle(guiDrawing, 0.0, startY, (double)this.f_96543_ * prideAnimationProgress, h, -2137481);
        GuiHelper.drawRectangle(guiDrawing, 0.0, startY + h, (double)this.f_96543_ * prideAnimationProgress, h, -290456);
        GuiHelper.drawRectangle(guiDrawing, 0.0, startY + h * 2, (double)this.f_96543_ * prideAnimationProgress, h, -795796);
        GuiHelper.drawRectangle(guiDrawing, 0.0, startY + h * 3, (double)this.f_96543_ * prideAnimationProgress, h, -8735854);
        GuiHelper.drawRectangle(guiDrawing, 0.0, startY + h * 4, (double)this.f_96543_ * prideAnimationProgress, h, -11830084);
        GuiHelper.drawRectangle(guiDrawing, 0.0, startY + h * 5, (double)this.f_96543_ * prideAnimationProgress, h, -9484148);
        graphicsHolder.pop();
    }

    @Override
    public void onClose2() {
        if (!this.closing) {
            if (!this.discardConfig) {
                JCMClient.getConfig().write();
            } else {
                JCMClient.getConfig().read();
            }
        }
        super.onClose2();
    }

    public static void openLatestLog() {
        File latestLog = Paths.get(MinecraftClient.getInstance().getRunDirectoryMapped().toString(), "logs", "latest.log").toFile();
        if (latestLog.exists()) {
            Util.getOperatingSystem().open(latestLog);
        }
    }

    public static void openLatestCrashReport() {
        File[] crashReports;
        File crashReportDir = Paths.get(MinecraftClient.getInstance().getRunDirectoryMapped().toString(), "crash-reports").toFile();
        if (crashReportDir.exists() && (crashReports = crashReportDir.listFiles()) != null && crashReportDir.length() > 0L) {
            SimpleDateFormat crashReportFormat = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
            Arrays.sort(crashReports, (o1, o2) -> {
                String filename1 = o1.getName().replace("crash-", "").replace("-client", "");
                String filename2 = o2.getName().replace("crash-", "").replace("-client", "");
                if (o1 == o2) {
                    return 0;
                }
                try {
                    long ts1 = crashReportFormat.parse(filename1).getTime();
                    long ts2 = crashReportFormat.parse(filename2).getTime();
                    return ts1 > ts2 ? -1 : 1;
                }
                catch (ParseException e) {
                    JCMLogger.debug("Cannot compare crash report file name " + filename1 + " <-> " + filename2, new Object[0]);
                    return 1;
                }
            });
            JCMLogger.debug("Latest crash report is: " + crashReports[0].getName(), new Object[0]);
            Util.getOperatingSystem().open(crashReports[0]);
        }
    }
}

