/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.render.gui.widget;

import com.lx862.jcm.mod.render.RenderHelper;
import com.lx862.jcm.mod.render.gui.widget.MappedWidget;
import com.lx862.jcm.mod.render.gui.widget.MultiWidgetContainer;
import java.util.ArrayList;
import java.util.List;
import org.mtr.mapping.mapper.ClickableWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;

public class HorizontalWidgetSet
extends ClickableWidgetExtension
implements MultiWidgetContainer,
RenderHelper {
    public int widgetXMargin;
    private final List<MappedWidget> widgets = new ArrayList<MappedWidget>();

    public HorizontalWidgetSet(int widgetXMargin) {
        super(0, 0, 0, 20);
        this.widgetXMargin = widgetXMargin;
    }

    public HorizontalWidgetSet() {
        this(5);
    }

    public void setXYSize(int x, int y, int width, int height) {
        this.setX2(x);
        this.setY2(y);
        this.setWidth2(width);
        this.setHeightMapped(height);
        this.positionWidgets();
    }

    public void addWidget(MappedWidget widget) {
        this.widgets.add(widget);
    }

    public int getWidth2() {
        int total = 0;
        for (MappedWidget mappedWidget : this.widgets) {
            total += mappedWidget.getWidth();
            total += this.widgetXMargin;
        }
        if (total > 1) {
            total -= this.widgetXMargin;
        }
        return total;
    }

    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        for (MappedWidget mappedWidget : this.widgets) {
            mappedWidget.render(graphicsHolder, mouseX, mouseY, delta);
        }
    }

    public void setVisibleMapped(boolean visible) {
        for (MappedWidget widget : this.widgets) {
            widget.setVisible(visible);
        }
        super.setVisibleMapped(visible);
    }

    @Override
    public void setAllX(int newX) {
        super.setX2(newX);
        this.positionWidgets();
    }

    @Override
    public void setAllY(int newY) {
        super.setY2(newY);
        this.positionWidgets();
    }

    private void positionWidgets() {
        int accX = 0;
        for (MappedWidget widget : this.widgets) {
            widget.setX(this.getX2() + accX);
            widget.setY(this.getY2());
            int clampedWidth = Math.min(this.f_93618_ - accX, widget.getWidth());
            widget.setWidth(clampedWidth);
            accX += clampedWidth + this.widgetXMargin;
        }
    }
}

