/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.util;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.IntegerProperty;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldAccess;

public class BlockUtil {
    public static boolean canSurvive(Block instance, WorldAccess world, BlockPos pos, org.mtr.mapping.holder.Direction facing, int part, int totalWidthHeight) {
        BlockPos posRightOrUp;
        BlockState blockRightOrUp;
        BlockPos posLeftOrDown;
        BlockState blockLeftOrDown;
        boolean checkLeftOrBottom = part != 0;
        boolean checkRightOrTop = part != totalWidthHeight - 1;
        boolean canSurvive = true;
        if (checkLeftOrBottom && !(blockLeftOrDown = world.getBlockState(posLeftOrDown = pos.offset(facing.getOpposite()))).getBlock().equals((Object)instance)) {
            return false;
        }
        if (checkRightOrTop && !(blockRightOrUp = world.getBlockState(posRightOrUp = pos.offset(facing))).getBlock().equals((Object)instance)) {
            return false;
        }
        return canSurvive;
    }

    public static boolean isReplacable(World world, BlockPos startPos, org.mtr.mapping.holder.Direction direction, ItemPlacementContext ctx, int distance) {
        for (int i = 0; i < distance; ++i) {
            BlockPos posUp = startPos.offset(direction, i);
            BlockState blockState = world.getBlockState(posUp);
            if (blockState.canReplace(ctx)) continue;
            return false;
        }
        return true;
    }

    public static boolean getProperty(BlockState state, BooleanProperty property) {
        return (Boolean)BlockUtil.getProperty(state, new Property((net.minecraft.world.level.block.state.properties.Property)property.data));
    }

    public static org.mtr.mapping.holder.Direction getProperty(BlockState state, DirectionProperty property) {
        return org.mtr.mapping.holder.Direction.convert((Direction)((Direction)BlockUtil.getProperty(state, new Property((net.minecraft.world.level.block.state.properties.Property)property.data))));
    }

    public static int getProperty(BlockState state, IntegerProperty property) {
        return (Integer)BlockUtil.getProperty(state, new Property((net.minecraft.world.level.block.state.properties.Property)property.data));
    }

    public static <T extends Comparable<T>> T getProperty(BlockState state, Property<T> property) {
        return (T)(state.contains(property) ? state.get(property) : (Comparable)new ArrayList(property.getValues()).get(0));
    }

    @Nullable
    public static BlockEntity getBlockEntityOrNull(World world, BlockPos pos) {
        if (!world.isChunkLoaded(BlockUtil.getChunkCoords(pos.getX()), BlockUtil.getChunkCoords(pos.getZ()))) {
            return null;
        }
        return world.getBlockEntity(pos);
    }

    @Nullable
    public static BlockState getBlockState(World world, BlockPos pos) {
        if (!world.isChunkLoaded(BlockUtil.getChunkCoords(pos.getX()), BlockUtil.getChunkCoords(pos.getZ()))) {
            return null;
        }
        return world.getBlockState(pos);
    }

    private static int getChunkCoords(int pos) {
        return pos >> 4;
    }
}

