/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.core;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mtr.core.servlet.WebServlet;
import org.mtr.core.servlet.Webserver;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectList;
import org.mtr.libraries.javax.servlet.Servlet;
import org.mtr.libraries.org.eclipse.jetty.servlet.ServletHolder;
import top.mcmtr.core.servlet.MSDOperationServlet;
import top.mcmtr.core.simulation.MSDSimulator;

public class MSDMain {
    private final ObjectImmutableList<MSDSimulator> simulators;
    private final Webserver webserver;
    private final ScheduledExecutorService scheduledExecutorService;
    public static final int MILLISECONDS_PER_TICK = 10;
    public static final Logger MSD_CORE_LOG = LogManager.getLogger((String)"MSD_SERVER_LOGGER");

    public MSDMain(Path rootPath, int webserverPort, String ... dimensions) {
        ObjectArrayList tempSimulators = new ObjectArrayList();
        MSD_CORE_LOG.info("MSD server Loading files...");
        for (String dimension : dimensions) {
            tempSimulators.add((Object)new MSDSimulator(dimension, rootPath));
        }
        this.simulators = new ObjectImmutableList((ObjectList)tempSimulators);
        this.webserver = new Webserver(webserverPort);
        this.webserver.addServlet(new ServletHolder((Servlet)new WebServlet()), "/");
        this.webserver.addServlet(new ServletHolder((Servlet)new MSDOperationServlet(this.simulators)), "/msd/api/operation/*");
        this.webserver.start();
        this.scheduledExecutorService = Executors.newScheduledThreadPool(this.simulators.size());
        this.simulators.forEach(simulator -> this.scheduledExecutorService.scheduleAtFixedRate(simulator::tick, 0L, 10L, TimeUnit.MILLISECONDS));
        MSD_CORE_LOG.info("MSD server started with dimensions {}", (Object)Arrays.toString(dimensions));
    }

    public void save() {
        MSD_CORE_LOG.info("MSD server Starting quick save...");
        this.simulators.forEach(MSDSimulator::save);
    }

    public void stop() {
        MSD_CORE_LOG.info("MSD server Stopping...");
        this.webserver.stop();
        this.scheduledExecutorService.shutdown();
        Utilities.awaitTermination((ExecutorService)this.scheduledExecutorService);
        MSD_CORE_LOG.info("MSD server Starting full save...");
        this.simulators.forEach(MSDSimulator::stop);
        MSD_CORE_LOG.info("MSD server Stopped");
    }
}

