/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.core.data;

import org.mtr.core.data.Position;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import top.mcmtr.core.data.CatenaryMath;
import top.mcmtr.core.data.CatenaryType;
import top.mcmtr.core.data.MSDData;
import top.mcmtr.core.data.OffsetPosition;
import top.mcmtr.core.generated.data.CatenarySchema;

public final class Catenary
extends CatenarySchema {
    public final CatenaryMath catenaryMath;
    private final boolean reversePositions;

    public static Catenary copy(Catenary catenary, OffsetPosition offsetPositionStartNew, OffsetPosition offsetPositionEndNew) {
        return new Catenary(catenary.getPosition1(), catenary.getPosition2(), offsetPositionStartNew, offsetPositionEndNew, catenary.getCatenaryType());
    }

    public Catenary(Position positionStart, Position positionEnd, OffsetPosition offsetPositionStart, OffsetPosition offsetPositionEnd, CatenaryType catenaryType) {
        super(positionStart, positionEnd, offsetPositionStart, offsetPositionEnd, catenaryType);
        this.reversePositions = positionStart.compareTo(positionEnd) > 0;
        this.catenaryMath = this.reversePositions ? new CatenaryMath(positionEnd, positionStart, offsetPositionEnd, offsetPositionStart, catenaryType) : new CatenaryMath(positionStart, positionEnd, offsetPositionStart, offsetPositionEnd, catenaryType);
    }

    public Catenary(ReaderBase readerBase) {
        super(readerBase);
        this.reversePositions = this.positionStart.compareTo(this.positionEnd) > 0;
        this.catenaryMath = this.reversePositions ? new CatenaryMath(this.positionEnd, this.positionStart, this.offsetPositionEnd, this.offsetPositionStart, this.catenaryType) : new CatenaryMath(this.positionStart, this.positionEnd, this.offsetPositionStart, this.offsetPositionEnd, this.catenaryType);
    }

    public Position getPosition1() {
        return this.positionStart;
    }

    public Position getPosition2() {
        return this.positionEnd;
    }

    public OffsetPosition getOffsetPositionStart() {
        return this.offsetPositionStart;
    }

    public OffsetPosition getOffsetPositionEnd() {
        return this.offsetPositionEnd;
    }

    public CatenaryType getCatenaryType() {
        return this.catenaryType;
    }

    public boolean isValid() {
        return this.catenaryMath.verify();
    }

    public boolean closeTo(Position position, double radius) {
        return Utilities.isBetween((Position)position, (Position)this.positionStart, (Position)this.positionEnd, (double)radius);
    }

    void writePositionsToCatenaryCache(Object2ObjectOpenHashMap<Position, Object2ObjectOpenHashMap<Position, Catenary>> positionsToCatenary) {
        MSDData.put(positionsToCatenary, this.positionStart, this.positionEnd, oldValue -> this, Object2ObjectOpenHashMap::new);
        MSDData.put(positionsToCatenary, this.positionEnd, this.positionStart, oldValue -> this, Object2ObjectOpenHashMap::new);
    }

    public static boolean verifyPosition(Position positionStart, Position positionEnd, OffsetPosition offsetStart, OffsetPosition offsetEnd) {
        double zEnd;
        double yEnd;
        double xStart = (double)positionStart.getX() + offsetStart.getX();
        double yStart = (double)positionStart.getY() + offsetStart.getY();
        double zStart = (double)positionStart.getZ() + offsetStart.getZ();
        double xEnd = (double)positionEnd.getX() + offsetEnd.getX();
        return Math.sqrt((xEnd - xStart) * (xEnd - xStart) + ((yEnd = (double)positionEnd.getY() + offsetEnd.getY()) - yStart) * (yEnd - yStart) + ((zEnd = (double)positionEnd.getZ() + offsetEnd.getZ()) - zStart) * (zEnd - zStart)) > 0.0;
    }
}

