/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.core.legacy.data;

import org.mtr.core.data.Position;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.tool.Angle;
import org.mtr.core.tool.Utilities;
import org.mtr.core.tool.Vector;
import org.mtr.legacy.data.DataFixer;
import top.mcmtr.core.legacy.generated.data.RigidCatenaryConnectionSchema;

public final class RigidCatenaryNodeConnection
extends RigidCatenaryConnectionSchema {
    public RigidCatenaryNodeConnection(ReaderBase readerBase) {
        super(readerBase);
        this.updateData(readerBase);
    }

    public Position getEndPosition() {
        return DataFixer.fromLong((long)this.rigidCatenaryNodePos);
    }

    public long getEndPositionLong() {
        return this.rigidCatenaryNodePos;
    }

    public Angle getStartAngle() {
        return this.getAngle(false);
    }

    public Angle getEndAngle() {
        return this.getAngle(true);
    }

    private Angle getAngle(boolean reverse) {
        Vector vector1 = this.getPosition(0.0, reverse);
        Vector vector2 = this.getPosition(0.1, reverse);
        return Angle.fromAngle((float)((float)Math.toDegrees(Math.atan2(vector2.z - vector1.z, vector2.x - vector1.x))));
    }

    private Vector getPosition(double rawValue, boolean reverse) {
        double value;
        double count1 = Math.abs(this.tEnd1 - this.tStart1);
        double count2 = Math.abs(this.tEnd2 - this.tStart2);
        double clampedValue = Utilities.clamp((double)rawValue, (double)0.0, (double)(count1 + count2));
        double d = value = reverse ? count1 + count2 - clampedValue : clampedValue;
        if (value <= count1) {
            return RigidCatenaryNodeConnection.getPositionXZ(this.h1, this.k1, this.r1, (double)(this.reverseT1 ? -1 : 1) * value + this.tStart1, this.isStraight1);
        }
        return RigidCatenaryNodeConnection.getPositionXZ(this.h2, this.k2, this.r2, (double)(this.reverseT2 ? -1 : 1) * (value - count1) + this.tStart2, this.isStraight2);
    }

    private static Vector getPositionXZ(double h, double k, double r, double t, boolean isStraight) {
        if (isStraight) {
            return new Vector(h * t + k * (Math.abs(h) >= 0.5 && Math.abs(k) >= 0.5 ? 0.0 : r) + 0.5, 0.0, k * t + h * r + 0.5);
        }
        return new Vector(h + r * Math.cos(t / r) + 0.5, 0.0, k + r * Math.sin(t / r) + 0.5);
    }
}

