/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.core.operation;

import java.util.Collection;
import org.mtr.core.data.Position;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.serializer.SerializedDataBase;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.com.google.gson.JsonObject;
import top.mcmtr.core.data.Catenary;
import top.mcmtr.core.data.MSDClientData;
import top.mcmtr.core.data.RigidCatenary;
import top.mcmtr.core.generated.operation.MSDDataRequestSchema;
import top.mcmtr.core.operation.MSDDataResponse;
import top.mcmtr.core.simulation.MSDSimulator;

public final class MSDDataRequest
extends MSDDataRequestSchema {
    public MSDDataRequest(String clientId, Position clientPosition, long requestRadius) {
        super(clientId, clientPosition, requestRadius);
    }

    public MSDDataRequest(ReaderBase readerBase) {
        super(readerBase);
        this.updateData(readerBase);
    }

    public JsonObject getData(MSDSimulator simulator) {
        MSDDataResponse dataResponse = new MSDDataResponse(simulator);
        simulator.catenaryIdMap.forEach((catenaryId, catenary) -> {
            if (catenary.closeTo(this.clientPosition, this.requestRadius)) {
                if (this.existingCatenaryIds.contains(catenaryId)) {
                    dataResponse.addCatenary(catenary.getHexId());
                } else {
                    dataResponse.addCatenary((Catenary)((Object)catenary));
                }
            }
        });
        simulator.rigidCatenaryIdMap.forEach((rigidCatenaryID, rigidCatenary) -> {
            if (rigidCatenary.closeTo(this.clientPosition, this.requestRadius)) {
                if (this.existingRigidCatenaryIds.contains(rigidCatenaryID)) {
                    dataResponse.addRigidCatenary(rigidCatenary.getHexId());
                } else {
                    dataResponse.addRigidCatenary((RigidCatenary)((Object)rigidCatenary));
                }
            }
        });
        return Utilities.getJsonObjectFromData((SerializedDataBase)dataResponse);
    }

    public void writeExistingIds(MSDClientData clientData) {
        this.existingCatenaryIds.addAll((Collection)clientData.catenaryIdMap.keySet());
        this.existingRigidCatenaryIds.addAll((Collection)clientData.rigidCatenaryIdMap.keySet());
    }
}

