/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.core.servlet;

import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.mtr.core.integration.Response;
import org.mtr.core.serializer.JsonReader;
import org.mtr.core.servlet.HttpResponseStatus;
import org.mtr.libraries.com.google.gson.JsonElement;
import org.mtr.libraries.com.google.gson.JsonObject;
import org.mtr.libraries.com.google.gson.JsonParser;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import org.mtr.libraries.javax.servlet.AsyncContext;
import org.mtr.libraries.javax.servlet.ServletOutputStream;
import org.mtr.libraries.javax.servlet.WriteListener;
import org.mtr.libraries.javax.servlet.http.HttpServlet;
import org.mtr.libraries.javax.servlet.http.HttpServletRequest;
import org.mtr.libraries.javax.servlet.http.HttpServletResponse;
import top.mcmtr.core.MSDMain;
import top.mcmtr.core.simulation.MSDSimulator;

public abstract class MSDServletBase
extends HttpServlet {
    private final ObjectImmutableList<MSDSimulator> simulators;

    protected MSDServletBase(ObjectImmutableList<MSDSimulator> simulators) {
        this.simulators = simulators;
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.doPost(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        AsyncContext asyncContext = httpServletRequest.startAsync();
        asyncContext.setTimeout(0L);
        long currentMillis = System.currentTimeMillis();
        JsonElement jsonElement = JsonParser.parseReader((Reader)httpServletRequest.getReader());
        JsonReader jsonReader = new JsonReader((JsonElement)(jsonElement.isJsonNull() ? new JsonObject() : jsonElement));
        if (MSDServletBase.tryGetParameter(httpServletRequest, "dimensions").equals("all")) {
            this.simulators.forEach(simulator -> this.run(httpServletRequest, null, null, jsonReader, currentMillis, (MSDSimulator)simulator));
            MSDServletBase.buildResponseObject(httpServletResponse, asyncContext, currentMillis, null, HttpResponseStatus.OK, new String[0]);
        } else {
            int dimension = 0;
            try {
                dimension = Integer.parseInt(MSDServletBase.tryGetParameter(httpServletRequest, "dimension"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (dimension < 0 || dimension >= this.simulators.size()) {
                MSDServletBase.buildResponseObject(httpServletResponse, asyncContext, currentMillis, null, HttpResponseStatus.BAD_REQUEST, "Invalid Dimension");
            } else {
                this.run(httpServletRequest, httpServletResponse, asyncContext, jsonReader, currentMillis, (MSDSimulator)this.simulators.get(dimension));
            }
        }
    }

    protected abstract void getContent(String var1, String var2, Object2ObjectAVLTreeMap<String, String> var3, JsonReader var4, long var5, MSDSimulator var7, Consumer<JsonObject> var8);

    private void run(HttpServletRequest httpServletRequest, @Nullable HttpServletResponse httpServletResponse, @Nullable AsyncContext asyncContext, JsonReader jsonReader, long currentMillis, MSDSimulator simulator) {
        String data;
        String endpoint;
        String path = httpServletRequest.getPathInfo();
        if (path != null) {
            String[] pathSplit = path.substring(1).split("\\.")[0].split("/");
            endpoint = pathSplit.length > 0 ? pathSplit[0] : "";
            data = pathSplit.length > 1 ? pathSplit[1] : "";
        } else {
            endpoint = "";
            data = "";
        }
        Object2ObjectAVLTreeMap parameters = new Object2ObjectAVLTreeMap();
        httpServletRequest.getParameterMap().forEach((key, values) -> {
            if (((String[])values).length > 0) {
                parameters.put(key, (Object)values[0]);
            }
        });
        simulator.run(() -> this.getContent(endpoint, data, (Object2ObjectAVLTreeMap<String, String>)parameters, jsonReader, currentMillis, simulator, jsonObject -> {
            if (httpServletResponse != null && asyncContext != null) {
                MSDServletBase.buildResponseObject(httpServletResponse, asyncContext, currentMillis, jsonObject, jsonObject == null ? HttpResponseStatus.NOT_FOUND : HttpResponseStatus.OK, endpoint, data);
            }
        }));
    }

    public static void sendResponse(final HttpServletResponse httpServletResponse, final AsyncContext asyncContext, String content, String contentType, final HttpResponseStatus httpResponseStatus) {
        try {
            final ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            final ByteBuffer byteBuffer = ByteBuffer.wrap(content.getBytes(StandardCharsets.UTF_8));
            httpServletResponse.addHeader("Content-Type", contentType);
            servletOutputStream.setWriteListener(new WriteListener(){

                public void onWritePossible() throws IOException {
                    while (servletOutputStream.isReady()) {
                        if (!byteBuffer.hasRemaining()) {
                            httpServletResponse.setStatus(httpResponseStatus.code);
                            asyncContext.complete();
                            return;
                        }
                        servletOutputStream.write((int)byteBuffer.get());
                    }
                }

                public void onError(Throwable throwable) {
                    asyncContext.complete();
                }
            });
        }
        catch (IllegalStateException servletOutputStream) {
        }
        catch (Exception e) {
            MSDMain.MSD_CORE_LOG.error("MSD Servlet send response error", (Throwable)e);
        }
    }

    public static String getMimeType(String fileName) {
        String fileExtension;
        String[] fileNameSplit = fileName.split("\\.");
        switch (fileExtension = fileNameSplit.length == 0 ? "" : fileNameSplit[fileNameSplit.length - 1]) {
            case "js": {
                return "text/javascript";
            }
            case "json": {
                return "application/json";
            }
        }
        return "text/" + fileExtension;
    }

    private static void buildResponseObject(HttpServletResponse httpServletResponse, AsyncContext asyncContext, long currentMillis, @Nullable JsonObject data, HttpResponseStatus httpResponseStatus, String ... parameters) {
        StringBuilder reasonPhrase = new StringBuilder(httpResponseStatus.description);
        String trimmedParameters = Arrays.stream(parameters).filter(parameter -> !parameter.isEmpty()).collect(Collectors.joining(", "));
        if (!trimmedParameters.isEmpty()) {
            reasonPhrase.append(" - ").append(trimmedParameters);
        }
        MSDServletBase.sendResponse(httpServletResponse, asyncContext, new Response(httpResponseStatus.code, currentMillis, reasonPhrase.toString(), data).getJson().toString(), MSDServletBase.getMimeType("json"), httpResponseStatus);
    }

    private static String tryGetParameter(HttpServletRequest httpServletRequest, String parameter) {
        return httpServletRequest.getParameterMap().getOrDefault(parameter, new String[]{""})[0];
    }
}

