/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.core.simulation;

import java.nio.file.Path;
import org.mtr.core.serializer.SerializedDataBaseWithId;
import org.mtr.core.simulation.FileLoader;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArraySet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectSet;
import top.mcmtr.core.MSDMain;
import top.mcmtr.core.data.Catenary;
import top.mcmtr.core.data.MSDData;
import top.mcmtr.core.data.RigidCatenary;
import top.mcmtr.core.legacy.data.LegacyCatenaryLoader;

public class MSDSimulator
extends MSDData
implements Utilities {
    private boolean autoSave = false;
    private final String dimension;
    private final FileLoader<Catenary> fileLoaderCatenaries;
    private final FileLoader<RigidCatenary> fileLoaderRigidCatenaries;
    private final ObjectArrayList<Runnable> queuedRuns = new ObjectArrayList();
    private static final String KEY_CATENARIES = "catenaries";
    private static final String KEY_RIGID_CATENARIES = "rigid_catenaries";

    public MSDSimulator(String dimension, Path rootPath) {
        this.dimension = dimension;
        long startMillis = System.currentTimeMillis();
        Path savePath = rootPath.resolve(dimension);
        LegacyCatenaryLoader.loadCatenary(savePath, (ObjectArraySet<Catenary>)this.catenaries);
        LegacyCatenaryLoader.loadTransCatenary(savePath, (ObjectArraySet<Catenary>)this.catenaries);
        LegacyCatenaryLoader.loadRigidCatenary(savePath, (ObjectArraySet<RigidCatenary>)this.rigidCatenaries);
        this.fileLoaderCatenaries = new FileLoader((ObjectSet)this.catenaries, Catenary::new, savePath, KEY_CATENARIES);
        this.fileLoaderRigidCatenaries = new FileLoader((ObjectSet)this.rigidCatenaries, RigidCatenary::new, savePath, KEY_RIGID_CATENARIES);
        long endMillis = System.currentTimeMillis();
        MSDMain.MSD_CORE_LOG.info("MSD Data loading complete for {} in {} second(s)", (Object)dimension, (Object)Float.valueOf((float)(endMillis - startMillis) / 1000.0f));
        this.sync();
    }

    public void tick() {
        try {
            Runnable runnable;
            if (this.autoSave) {
                this.save(true);
                this.autoSave = false;
            }
            if (!this.queuedRuns.isEmpty() && (runnable = (Runnable)this.queuedRuns.remove(0)) != null) {
                runnable.run();
            }
        }
        catch (Exception e) {
            MSDMain.MSD_CORE_LOG.error("MSD Simulator tick error", (Throwable)e);
            throw e;
        }
    }

    public void save() {
        this.autoSave = true;
    }

    public void stop() {
        this.save(false);
    }

    public void run(Runnable runnable) {
        this.queuedRuns.add((Object)runnable);
    }

    private void save(boolean useReducedHash) {
        long startMillis = System.currentTimeMillis();
        this.save(this.fileLoaderCatenaries, useReducedHash);
        this.save(this.fileLoaderRigidCatenaries, useReducedHash);
        MSDMain.MSD_CORE_LOG.info("MSD Save complete for {} in {} second(s)", (Object)this.dimension, (Object)Float.valueOf((float)(System.currentTimeMillis() - startMillis) / 1000.0f));
    }

    private <T extends SerializedDataBaseWithId> void save(FileLoader<T> fileLoader, boolean useReducedHash) {
        IntIntImmutablePair saveCounts = fileLoader.save(useReducedHash);
        if (saveCounts.leftInt() > 0) {
            MSDMain.MSD_CORE_LOG.info("- MSD Changed {}: {}", (Object)fileLoader.key, (Object)saveCounts.leftInt());
        }
        if (saveCounts.rightInt() > 0) {
            MSDMain.MSD_CORE_LOG.info("- MSD Deleted {}: {}", (Object)fileLoader.key, (Object)saveCounts.rightInt());
        }
    }
}

