/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.mod;

import java.io.File;
import java.net.ServerSocket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.world.level.Level;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mtr.core.data.Position;
import org.mtr.core.tool.RequestHelper;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ChunkManager;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MathHelper;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldSavePath;
import org.mtr.mapping.mapper.MinecraftServerHelper;
import org.mtr.mapping.registry.Registry;
import top.mcmtr.core.MSDMain;
import top.mcmtr.mod.BlockEntityTypes;
import top.mcmtr.mod.Blocks;
import top.mcmtr.mod.CreativeModeTabs;
import top.mcmtr.mod.Items;
import top.mcmtr.mod.packet.MSDPacketDeleteData;
import top.mcmtr.mod.packet.MSDPacketOpenBlockEntityScreen;
import top.mcmtr.mod.packet.MSDPacketOpenCatenaryScreen;
import top.mcmtr.mod.packet.MSDPacketOpenCatenaryWithModelScreen;
import top.mcmtr.mod.packet.MSDPacketOpenCustomScreen;
import top.mcmtr.mod.packet.MSDPacketRequestData;
import top.mcmtr.mod.packet.MSDPacketResetData;
import top.mcmtr.mod.packet.MSDPacketUpdateCatenaryNode;
import top.mcmtr.mod.packet.MSDPacketUpdateCustomText;
import top.mcmtr.mod.packet.MSDPacketUpdateData;
import top.mcmtr.mod.packet.MSDPacketUpdateModel;
import top.mcmtr.mod.packet.MSDPacketUpdateYamanoteRailwaySignConfig;

public class Init
implements Utilities {
    private static MSDMain main;
    private static int serverPort;
    public static final String MOD_ID = "msd";
    public static final Logger MSD_LOGGER;
    public static final Registry REGISTRY;
    private static final ObjectArrayList<String> WORLD_ID_LIST;
    private static final RequestHelper REQUEST_HELPER;

    public static void init() {
        Blocks.init();
        Items.init();
        BlockEntityTypes.init();
        CreativeModeTabs.init();
        REGISTRY.setupPackets(new Identifier(MOD_ID, "packet"));
        REGISTRY.registerPacket(MSDPacketDeleteData.class, MSDPacketDeleteData::new);
        REGISTRY.registerPacket(MSDPacketRequestData.class, MSDPacketRequestData::new);
        REGISTRY.registerPacket(MSDPacketUpdateData.class, MSDPacketUpdateData::new);
        REGISTRY.registerPacket(MSDPacketResetData.class, MSDPacketResetData::new);
        REGISTRY.registerPacket(MSDPacketOpenCatenaryScreen.class, MSDPacketOpenCatenaryScreen::new);
        REGISTRY.registerPacket(MSDPacketUpdateCatenaryNode.class, MSDPacketUpdateCatenaryNode::new);
        REGISTRY.registerPacket(MSDPacketUpdateYamanoteRailwaySignConfig.class, MSDPacketUpdateYamanoteRailwaySignConfig::new);
        REGISTRY.registerPacket(MSDPacketOpenBlockEntityScreen.class, MSDPacketOpenBlockEntityScreen::new);
        REGISTRY.registerPacket(MSDPacketOpenCustomScreen.class, MSDPacketOpenCustomScreen::new);
        REGISTRY.registerPacket(MSDPacketUpdateCustomText.class, MSDPacketUpdateCustomText::new);
        REGISTRY.registerPacket(MSDPacketUpdateModel.class, MSDPacketUpdateModel::new);
        REGISTRY.registerPacket(MSDPacketOpenCatenaryWithModelScreen.class, MSDPacketOpenCatenaryWithModelScreen::new);
        Init.REGISTRY.eventRegistry.registerServerStarted(minecraftServer -> {
            WORLD_ID_LIST.clear();
            MinecraftServerHelper.iterateWorlds((MinecraftServer)minecraftServer, serverWorld -> WORLD_ID_LIST.add((Object)Init.getWorldId(new World((Level)serverWorld.data))));
            int defaultPort = Init.getDefaultPortFromConfig(minecraftServer);
            serverPort = Init.findFreePort(defaultPort);
            main = new MSDMain(minecraftServer.getSavePath(WorldSavePath.getRootMapped()).resolve(MOD_ID), serverPort, (String[])WORLD_ID_LIST.toArray((Object[])new String[0]));
        });
        Init.REGISTRY.eventRegistry.registerPlayerDisconnect((minecraftServer, serverPlayerEntity) -> {
            if (main != null) {
                main.save();
            }
        });
        Init.REGISTRY.eventRegistry.registerServerStopping(minecraftServer -> {
            if (main != null) {
                main.stop();
            }
        });
        REGISTRY.init();
    }

    public static void sendHttpRequest(String endpoint, @Nullable World world, String content, @Nullable Consumer<String> consumer) {
        REQUEST_HELPER.sendRequest(String.format("http://localhost:%s/msd/api/%s?%s", serverPort, endpoint, world == null ? "dimensions=all" : "dimension=" + WORLD_ID_LIST.indexOf((Object)Init.getWorldId(world))), content, consumer);
    }

    public static BlockPos positionToBlockPos(Position position) {
        return new BlockPos((int)position.getX(), (int)position.getY(), (int)position.getZ());
    }

    public static Position blockPosToPosition(BlockPos blockPos) {
        return new Position((long)blockPos.getX(), (long)blockPos.getY(), (long)blockPos.getZ());
    }

    public static BlockPos newBlockPos(double x, double y, double z) {
        return new BlockPos(MathHelper.floor((double)x), MathHelper.floor((double)y), MathHelper.floor((double)z));
    }

    public static boolean isChunkLoaded(World world, ChunkManager chunkManager, BlockPos blockPos) {
        return chunkManager.getWorldChunk(blockPos.getX() / 16, blockPos.getZ() / 16) != null && world.isRegionLoaded(blockPos, blockPos);
    }

    private static int getDefaultPortFromConfig(MinecraftServer minecraftServer) {
        Path filePath = minecraftServer.getRunDirectory().toPath().resolve("config/msd_webserver_port.txt");
        int defaultPort = 8989;
        try {
            return Integer.parseInt(FileUtils.readFileToString((File)filePath.toFile(), (Charset)StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            try {
                Files.write(filePath, String.valueOf(8989).getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (Exception notfound) {
                Init.logException(notfound, "MSD get default server port error");
            }
            return 8989;
        }
    }

    private static int findFreePort(int startingPort) {
        int i = Math.max(1025, startingPort);
        while (i <= 65535) {
            int n;
            ServerSocket serverSocket = new ServerSocket(i);
            try {
                int port = serverSocket.getLocalPort();
                MSD_LOGGER.info("MSD Found available server port: {}", (Object)port);
                n = port;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        serverSocket.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception ignored) {
                    MSD_LOGGER.info("port: {} is used, ignore.", (Object)i);
                    ++i;
                }
            }
            serverSocket.close();
            return n;
        }
        return 0;
    }

    private static String getWorldId(World world) {
        Identifier identifier = MinecraftServerHelper.getWorldId((World)world);
        return String.format("%s/%s", identifier.getNamespace(), identifier.getPath());
    }

    public static void logException(Exception e, String message) {
        MSD_LOGGER.error(message, (Throwable)e);
    }

    static {
        MSD_LOGGER = LogManager.getLogger((String)"MTR-Station-Decoration");
        REGISTRY = new Registry();
        WORLD_ID_LIST = new ObjectArrayList();
        REQUEST_HELPER = new RequestHelper(false);
    }
}

