/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.mod.packet;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.level.Level;
import org.mtr.core.integration.Response;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.com.google.gson.JsonObject;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.MinecraftServerHelper;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;
import top.mcmtr.mod.Init;

public abstract class MSDPacketRequestResponseBase
extends PacketHandler {
    private final String content;

    public MSDPacketRequestResponseBase(PacketBufferReceiver packetBufferReceiver) {
        this.content = packetBufferReceiver.readString();
    }

    public MSDPacketRequestResponseBase(String content) {
        this.content = content;
    }

    public void write(PacketBufferSender packetBufferSender) {
        packetBufferSender.writeString(this.content);
    }

    public void runServer(MinecraftServer minecraftServer, ServerPlayerEntity serverPlayerEntity) {
        this.runServerOutbound(serverPlayerEntity.getServerWorld(), serverPlayerEntity);
    }

    public final void runClient() {
        this.runClientInbound(Response.create((JsonObject)Utilities.parseJson((String)this.content)));
    }

    public final void runServerOutbound(ServerWorld serverWorld, @Nullable ServerPlayerEntity serverPlayerEntity) {
        Init.sendHttpRequest(this.getEndpoint(), new World((Level)serverWorld.data), this.content, this.responseType() == ResponseType.NONE ? null : response -> {
            if (this.responseType() == ResponseType.PLAYER) {
                if (serverPlayerEntity != null) {
                    Init.REGISTRY.sendPacketToClient(serverPlayerEntity, (PacketHandler)this.getInstance((String)response));
                }
            } else {
                MinecraftServerHelper.iteratePlayers((ServerWorld)serverWorld, serverPlayerEntityNew -> Init.REGISTRY.sendPacketToClient(serverPlayerEntityNew, (PacketHandler)this.getInstance((String)response)));
            }
            this.runServerInbound(serverWorld, (String)response);
        });
    }

    protected abstract void runServerInbound(ServerWorld var1, String var2);

    protected abstract void runClientInbound(Response var1);

    protected abstract MSDPacketRequestResponseBase getInstance(String var1);

    @Nonnull
    protected abstract String getEndpoint();

    protected abstract ResponseType responseType();

    protected static enum ResponseType {
        NONE,
        PLAYER,
        ALL;

    }
}

