/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.mod.packet;

import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;
import top.mcmtr.core.data.OffsetPosition;
import top.mcmtr.mod.blocks.BlockCatenaryNode;

public final class MSDPacketUpdateCatenaryNode
extends PacketHandler {
    private final BlockPos blockPos;
    private final OffsetPosition offsetPosition;

    public MSDPacketUpdateCatenaryNode(PacketBufferReceiver packetBufferReceiver) {
        this.blockPos = BlockPos.fromLong((long)packetBufferReceiver.readLong());
        double x = packetBufferReceiver.readDouble();
        double y = packetBufferReceiver.readDouble();
        double z = packetBufferReceiver.readDouble();
        this.offsetPosition = new OffsetPosition(x, y, z);
    }

    public MSDPacketUpdateCatenaryNode(BlockPos blockPos, OffsetPosition offsetPosition) {
        this.blockPos = blockPos;
        this.offsetPosition = offsetPosition;
    }

    public void write(PacketBufferSender packetBufferSender) {
        packetBufferSender.writeLong(this.blockPos.asLong());
        packetBufferSender.writeDouble(this.offsetPosition.getX());
        packetBufferSender.writeDouble(this.offsetPosition.getY());
        packetBufferSender.writeDouble(this.offsetPosition.getZ());
    }

    public void runServer(MinecraftServer minecraftServer, ServerPlayerEntity serverPlayerEntity) {
        BlockEntity blockEntity = serverPlayerEntity.getEntityWorld().getBlockEntity(this.blockPos);
        if (blockEntity != null && blockEntity.data instanceof BlockCatenaryNode.BlockCatenaryNodeEntity) {
            ((BlockCatenaryNode.BlockCatenaryNodeEntity)((Object)blockEntity.data)).setOffsetPosition(this.offsetPosition);
        }
    }
}

