/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.core;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mtr.core.data.Depot;
import org.mtr.core.servlet.OBAServlet;
import org.mtr.core.servlet.OperationServlet;
import org.mtr.core.servlet.SystemMapServlet;
import org.mtr.core.servlet.WebServlet;
import org.mtr.core.servlet.Webserver;
import org.mtr.core.simulation.Simulator;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import org.mtr.libraries.org.eclipse.jetty.servlet.ServletHolder;

@ParametersAreNonnullByDefault
public class Main {
    private final ObjectImmutableList<Simulator> simulators;
    private final Webserver webserver;
    private final ScheduledExecutorService scheduledExecutorService;
    public static final Logger LOGGER = LogManager.getLogger((String)"TransportSimulationCore");
    public static final int MILLISECONDS_PER_TICK = 10;

    public static void main(String[] args2) {
        try {
            int i = 0;
            Path rootPath = Paths.get(args2[i++], new String[0]);
            int webserverPort = Integer.parseInt(args2[i++]);
            int clientWebserverPort = Integer.parseInt(args2[i++]);
            String[] dimensions = new String[args2.length - i];
            System.arraycopy(args2, i, dimensions, 0, dimensions.length);
            Main main = new Main(rootPath, webserverPort, clientWebserverPort, dimensions);
            main.readConsoleInput();
        }
        catch (Exception e) {
            Main.printHelp();
            LOGGER.error("", (Throwable)e);
        }
    }

    public Main(Path rootPath, int webserverPort, int clientWebserverPort, String ... dimensions) {
        ObjectArrayList<Simulator> tempSimulators = new ObjectArrayList<Simulator>();
        LOGGER.info("Loading files...");
        for (String dimension : dimensions) {
            tempSimulators.add(new Simulator(dimension, dimensions, rootPath, clientWebserverPort));
        }
        this.simulators = new ObjectImmutableList(tempSimulators);
        this.webserver = new Webserver(webserverPort);
        this.webserver.addServlet(new ServletHolder(new WebServlet()), "/");
        this.webserver.addServlet(new ServletHolder(new OperationServlet(this.simulators)), "/mtr/api/operation/*");
        this.webserver.addServlet(new ServletHolder(new SystemMapServlet(this.simulators)), "/mtr/api/map/stations-and-routes");
        this.webserver.addServlet(new ServletHolder(new OBAServlet(this.simulators)), "/oba/api/where/*");
        this.webserver.start();
        this.scheduledExecutorService = Executors.newScheduledThreadPool(this.simulators.size());
        this.simulators.forEach(simulator -> this.scheduledExecutorService.scheduleAtFixedRate(simulator::tick, 0L, 10L, TimeUnit.MILLISECONDS));
        LOGGER.info("Server started with dimensions {}", (Object)Arrays.toString(dimensions));
    }

    public void save() {
        LOGGER.info("Starting quick save...");
        this.simulators.forEach(Simulator::save);
    }

    public void stop() {
        LOGGER.info("Stopping...");
        this.webserver.stop();
        this.scheduledExecutorService.shutdown();
        Utilities.awaitTermination(this.scheduledExecutorService);
        LOGGER.info("Starting full save...");
        this.simulators.forEach(Simulator::stop);
        LOGGER.info("Stopped");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readConsoleInput() {
        try {
            block16: while (true) {
                String[] input = new BufferedReader(new InputStreamReader(System.in)).readLine().trim().toLowerCase(Locale.ENGLISH).replaceAll("[^a-z ]", "").split(" ");
                switch (input[0]) {
                    case "exit": 
                    case "stop": 
                    case "quit": {
                        this.stop();
                        return;
                    }
                    case "save": 
                    case "save-all": {
                        this.save();
                        continue block16;
                    }
                    case "generate": 
                    case "regenerate": {
                        StringBuilder generateKey = new StringBuilder();
                        for (int i = 1; i < input.length; ++i) {
                            generateKey.append(input[i]).append(" ");
                        }
                        this.simulators.forEach(simulator -> Depot.generateDepotsByName(simulator, generateKey.toString(), null));
                        continue block16;
                    }
                }
                LOGGER.info(String.format("Unknown command \"%s\"", input[0]));
            }
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            this.stop();
            return;
        }
    }

    private static void printHelp() {
        LOGGER.info("Usage:");
        LOGGER.info("java -jar Transport-Simulation-Core.jar <rootPath> <webserverPort> <dimensions...>");
    }
}

