/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.core.generated.data;

import javax.annotation.Nonnull;
import org.mtr.core.data.Position;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.serializer.SerializedDataBase;
import org.mtr.core.serializer.WriterBase;
import org.mtr.core.tool.Angle;
import org.mtr.core.tool.EnumHelper;

public abstract class PathDataSchema
implements SerializedDataBase {
    protected final long savedRailBaseId;
    protected final long dwellTime;
    protected final long stopIndex;
    protected final double startDistance;
    protected final double endDistance;
    protected final Position startPosition;
    protected final Angle startAngle;
    protected final Position endPosition;
    protected final Angle endAngle;

    protected PathDataSchema(long savedRailBaseId, long dwellTime, long stopIndex, double startDistance, double endDistance, Position startPosition, Angle startAngle, Position endPosition, Angle endAngle) {
        this.savedRailBaseId = savedRailBaseId;
        this.dwellTime = dwellTime;
        this.stopIndex = stopIndex;
        this.startDistance = startDistance;
        this.endDistance = endDistance;
        this.startPosition = startPosition;
        this.startAngle = startAngle;
        this.endPosition = endPosition;
        this.endAngle = endAngle;
    }

    protected PathDataSchema(ReaderBase readerBase) {
        this.savedRailBaseId = readerBase.getLong("savedRailBaseId", 0L);
        this.dwellTime = readerBase.getLong("dwellTime", 0L);
        this.stopIndex = readerBase.getLong("stopIndex", 0L);
        this.startDistance = readerBase.getDouble("startDistance", 0.0);
        this.endDistance = readerBase.getDouble("endDistance", 0.0);
        this.startPosition = new Position(readerBase.getChild("startPosition"));
        this.startAngle = EnumHelper.valueOf(Angle.values()[0], readerBase.getString("startAngle", ""));
        this.endPosition = new Position(readerBase.getChild("endPosition"));
        this.endAngle = EnumHelper.valueOf(Angle.values()[0], readerBase.getString("endAngle", ""));
    }

    @Override
    public void updateData(ReaderBase readerBase) {
    }

    @Override
    public void serializeData(WriterBase writerBase) {
        writerBase.writeLong("savedRailBaseId", this.savedRailBaseId);
        writerBase.writeLong("dwellTime", this.dwellTime);
        writerBase.writeLong("stopIndex", this.stopIndex);
        writerBase.writeDouble("startDistance", this.startDistance);
        writerBase.writeDouble("endDistance", this.endDistance);
        if (this.startPosition != null) {
            this.startPosition.serializeData(writerBase.writeChild("startPosition"));
        }
        writerBase.writeString("startAngle", this.startAngle.toString());
        if (this.endPosition != null) {
            this.endPosition.serializeData(writerBase.writeChild("endPosition"));
        }
        writerBase.writeString("endAngle", this.endAngle.toString());
    }

    @Nonnull
    public String toString() {
        return "savedRailBaseId: " + this.savedRailBaseId + "\ndwellTime: " + this.dwellTime + "\nstopIndex: " + this.stopIndex + "\nstartDistance: " + this.startDistance + "\nendDistance: " + this.endDistance + "\nstartPosition: " + this.startPosition + "\nstartAngle: " + (Object)((Object)this.startAngle) + "\nendPosition: " + this.endPosition + "\nendAngle: " + (Object)((Object)this.endAngle) + "\n";
    }
}

