/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.core.generated.map;

import javax.annotation.Nonnull;
import org.mtr.core.data.Route;
import org.mtr.core.map.RouteStation;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.serializer.SerializedDataBase;
import org.mtr.core.serializer.WriterBase;
import org.mtr.core.tool.EnumHelper;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;

public abstract class RouteSchema
implements SerializedDataBase {
    protected final String name;
    protected final String color;
    protected final String number;
    protected final String type;
    protected final Route.CircularState circularState;
    protected final ObjectArrayList<RouteStation> stations = new ObjectArrayList();

    protected RouteSchema(String name, String color, String number, String type, Route.CircularState circularState) {
        this.name = name;
        this.color = color;
        this.number = number;
        this.type = type;
        this.circularState = circularState;
    }

    protected RouteSchema(ReaderBase readerBase) {
        this.name = readerBase.getString("name", "");
        this.color = readerBase.getString("color", "");
        this.number = readerBase.getString("number", "");
        this.type = readerBase.getString("type", "");
        this.circularState = EnumHelper.valueOf(Route.CircularState.values()[0], readerBase.getString("circularState", ""));
    }

    @Override
    public void updateData(ReaderBase readerBase) {
        readerBase.iterateReaderArray("stations", this.stations::clear, readerBaseChild -> this.stations.add(new RouteStation((ReaderBase)readerBaseChild)));
    }

    @Override
    public void serializeData(WriterBase writerBase) {
        writerBase.writeString("name", this.name);
        writerBase.writeString("color", this.color);
        writerBase.writeString("number", this.number);
        writerBase.writeString("type", this.type);
        writerBase.writeString("circularState", this.circularState.toString());
        this.serializeStations(writerBase);
    }

    @Nonnull
    public String toString() {
        return "name: " + this.name + "\ncolor: " + this.color + "\nnumber: " + this.number + "\ntype: " + this.type + "\ncircularState: " + (Object)((Object)this.circularState) + "\nstations: " + this.stations + "\n";
    }

    protected void serializeStations(WriterBase writerBase) {
        writerBase.writeDataset(this.stations, "stations");
    }
}

