/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.core.operation;

import java.util.Collections;
import org.mtr.core.data.Platform;
import org.mtr.core.data.Station;
import org.mtr.core.generated.operation.ArrivalsRequestSchema;
import org.mtr.core.operation.ArrivalResponse;
import org.mtr.core.operation.ArrivalsResponse;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.core.simulation.Simulator;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.com.google.gson.JsonObject;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongConsumer;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongImmutableList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectAVLTreeSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;

public final class ArrivalsRequest
extends ArrivalsRequestSchema {
    public ArrivalsRequest(LongImmutableList platformIds, int maxCountPerPlatform, int maxCountTotal) {
        super(maxCountPerPlatform, maxCountTotal);
        this.platformIds.addAll(platformIds);
    }

    public ArrivalsRequest(ReaderBase readerBase) {
        super(readerBase);
        this.updateData(readerBase);
    }

    public JsonObject getArrivals(Simulator simulator, long currentMillis) {
        ObjectArrayList arrivalResponseList = new ObjectArrayList();
        ObjectAVLTreeSet visitedKeys = new ObjectAVLTreeSet();
        LongAVLTreeSet allPlatformIds = new LongAVLTreeSet();
        allPlatformIds.addAll(this.platformIds);
        this.platformIdsHex.forEach(platformIdHex -> allPlatformIds.add(ArrivalsRequest.parseHexId(platformIdHex)));
        this.stationIds.forEach(stationId -> ArrivalsRequest.iteratePlatformIds(simulator, stationId, allPlatformIds::add));
        this.stationIdsHex.forEach(stationIdHex -> ArrivalsRequest.iteratePlatformIds(simulator, ArrivalsRequest.parseHexId(stationIdHex), allPlatformIds::add));
        allPlatformIds.forEach(platformId -> {
            Platform platform = (Platform)simulator.platformIdMap.get(platformId);
            if (platform != null) {
                platform.routes.forEach(route -> route.depots.forEach(depot -> depot.savedRails.forEach(siding -> {
                    String key = String.format("%s_%s", platformId, siding.getId());
                    if (!visitedKeys.contains(key)) {
                        visitedKeys.add(key);
                        siding.getArrivals(currentMillis, platform, this.maxCountPerPlatform, arrivalResponseList);
                    }
                })));
            }
        });
        Collections.sort(arrivalResponseList);
        ArrivalsResponse arrivalsResponse = new ArrivalsResponse();
        int i = 0;
        while ((long)i < (this.maxCountTotal <= 0L ? (long)arrivalResponseList.size() : Math.min((long)arrivalResponseList.size(), this.maxCountTotal))) {
            arrivalsResponse.add((ArrivalResponse)arrivalResponseList.get(i));
            ++i;
        }
        return Utilities.getJsonObjectFromData(arrivalsResponse);
    }

    private static long parseHexId(String id) {
        try {
            return Long.parseUnsignedLong(id, 16);
        }
        catch (Exception ignored) {
            return 0L;
        }
    }

    private static void iteratePlatformIds(Simulator simulator, long stationId, LongConsumer consumer) {
        Station station = (Station)simulator.stationIdMap.get(stationId);
        if (station != null) {
            station.savedRails.forEach(platform -> consumer.accept(platform.getId()));
        }
    }
}

