/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.legacy.resource;

import java.util.Locale;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.mtr.core.data.TransportMode;
import org.mtr.core.serializer.JsonReader;
import org.mtr.core.serializer.JsonWriter;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.legacy.generated.resource.VehicleResourceSchema;
import org.mtr.libraries.com.google.gson.JsonArray;
import org.mtr.libraries.com.google.gson.JsonElement;
import org.mtr.libraries.com.google.gson.JsonObject;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArraySet;
import org.mtr.mapping.holder.Box;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mod.client.CustomResourceLoader;
import org.mtr.mod.resource.ModelProperties;
import org.mtr.mod.resource.PositionDefinitions;
import org.mtr.mod.resource.VehicleModel;
import org.mtr.mod.resource.VehicleResource;

public final class LegacyVehicleResource
extends VehicleResourceSchema {
    public LegacyVehicleResource(ReaderBase readerBase) {
        super(readerBase);
        this.updateData(readerBase);
    }

    public void convert(ObjectArrayList<VehicleResource> vehicleResources, String id) {
        for (int i = 0; i < Variation.values().length; ++i) {
            Variation variation = Variation.values()[i];
            VehicleResource[] baseVehicleResource = new VehicleResource[]{null};
            for (TransportMode transportMode : TransportMode.values()) {
                Object newBaseTrainType = transportMode == TransportMode.CABLE_CAR || this.base_train_type.startsWith("light_rail") ? (this.base_train_type.endsWith("_rht") || this.base_train_type.endsWith("_lht") ? this.base_train_type : this.base_train_type + "_lht") : String.format("%s_%s", this.base_train_type, variation.key);
                CustomResourceLoader.getVehicleById(transportMode, (String)newBaseTrainType, vehicleResource -> {
                    baseVehicleResource[0] = vehicleResource;
                });
                if (baseVehicleResource[0] != null) break;
            }
            JsonObject baseObject = new JsonObject();
            if (baseVehicleResource[0] != null) {
                baseVehicleResource[0].serializeData(new JsonWriter(baseObject));
            }
            baseObject.addProperty("id", String.format("mtr_custom_train_%s_%s", id, variation.key));
            baseObject.addProperty("name", this.name + variation.description);
            baseObject.addProperty("color", this.color);
            if (!this.description.isEmpty()) {
                baseObject.addProperty("description", this.description);
            }
            if (!this.wikipedia_article.isEmpty()) {
                baseObject.addProperty("wikipediaArticle", this.wikipedia_article);
            }
            if (baseVehicleResource[0] == null) {
                JsonObject[] propertiesObject = new JsonObject[]{null};
                if (!this.model_properties.isEmpty()) {
                    CustomResourceLoader.readResource(new Identifier(this.model_properties), jsonElement -> {
                        propertiesObject[0] = jsonElement.getAsJsonObject();
                    });
                }
                if (propertiesObject[0] == null) continue;
                double length = 0.0;
                double width = 0.0;
                double doorMax = 0.0;
                try {
                    baseObject.addProperty("transportMode", propertiesObject[0].get("transport_mode").getAsString());
                    length = propertiesObject[0].get("length").getAsDouble() + 1.0;
                    width = propertiesObject[0].get("width").getAsDouble();
                }
                catch (Exception ignored1) {
                    try {
                        String[] baseTrainTypeSplit = (this.base_train_type.startsWith("base_") ? this.base_train_type.replace("base_", "train_") : this.base_train_type).toUpperCase(Locale.ENGLISH).replace("CABLE_CAR", "CABLE-CAR").split("_");
                        baseObject.addProperty("transportMode", baseTrainTypeSplit[0].replace("CABLE-CAR", "CABLE_CAR"));
                        length = Double.parseDouble(baseTrainTypeSplit[1]) + 1.0;
                        width = Double.parseDouble(baseTrainTypeSplit[2]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    doorMax = propertiesObject[0].get("door_max").getAsDouble();
                }
                catch (Exception ignored1) {
                    // empty catch block
                }
                if (length == 0.0 || width == 0.0) continue;
                baseObject.addProperty("length", length);
                baseObject.addProperty("width", width);
                double bogiePosition = length < 10.0 ? 0.0 : length * 0.34;
                baseObject.addProperty("bogie1Position", -bogiePosition);
                baseObject.addProperty("bogie2Position", bogiePosition);
                baseObject.addProperty("couplingPadding1", (i & 1) == 0 ? 0 : 1);
                baseObject.addProperty("couplingPadding2", (i & 2) == 0 ? 0 : 1);
                baseObject.addProperty("hasGangway1", (!this.gangway_connection_id.isEmpty() || this.has_gangway_connection) && (i & 1) == 0);
                baseObject.addProperty("hasGangway2", (!this.gangway_connection_id.isEmpty() || this.has_gangway_connection) && (i & 2) == 0);
                baseObject.addProperty("hasBarrier1", !this.train_barrier_id.isEmpty() && (i & 1) == 0);
                baseObject.addProperty("hasBarrier2", !this.train_barrier_id.isEmpty() && (i & 2) == 0);
                baseObject.addProperty("bveSoundBaseResource", this.bve_sound_base_id);
                baseObject.addProperty("legacySpeedSoundBaseResource", this.speed_sound_base_id);
                baseObject.addProperty("legacySpeedSoundCount", this.speed_sound_count);
                baseObject.addProperty("legacyUseAccelerationSoundsWhenCoasting", this.accel_sound_at_coast);
                baseObject.addProperty("legacyConstantPlaybackSpeed", this.const_playback_speed);
                baseObject.addProperty("legacyDoorSoundBaseResource", this.door_sound_base_id);
                baseObject.addProperty("legacyDoorCloseSoundTime", this.door_close_sound_time);
                baseObject.addProperty("legacyDoorCloseSoundTime", this.door_close_sound_time);
                int currentCar = i == 0 ? 1 : (i == 2 ? 2 : 0);
                int totalCars = i == 3 ? 1 : 3;
                boolean isObj = false;
                ObjectArrayList<JsonObject> modelObjects = new ObjectArrayList<JsonObject>();
                String[] modelSplit = LegacyVehicleResource.splitWithEmptyStrings(this.model, '|');
                for (int j = 0; j < modelSplit.length; j += 2) {
                    String[] conditions;
                    String[] stringArray = conditions = j + 1 < modelSplit.length ? LegacyVehicleResource.splitWithEmptyStrings(modelSplit[j + 1], ';') : new String[]{};
                    if (conditions.length >= 2 && LegacyVehicleResource.matchesFilter(conditions[1].split(","), currentCar, totalCars) > LegacyVehicleResource.matchesFilter(conditions[0].split(","), currentCar, totalCars)) continue;
                    JsonObject modelObject2 = new JsonObject();
                    modelObject2.addProperty("modelResource", modelSplit[j]);
                    modelObject2.addProperty("textureResource", this.texture_id);
                    modelObject2.addProperty("flipTextureV", this.flipV);
                    modelObjects.add(modelObject2);
                    if (!modelSplit[j].endsWith(".obj")) continue;
                    isObj = true;
                }
                JsonArray positionDefinitionsArray = new JsonArray();
                JsonArray partsArray = new JsonArray();
                try {
                    this.processModel(currentCar, totalCars, isObj, propertiesObject[0].getAsJsonArray("parts_normal"), positionDefinitionsArray, partsArray, doorMax, "NORMAL", null, null);
                }
                catch (Exception modelObject2) {
                    // empty catch block
                }
                try {
                    this.processModel(currentCar, totalCars, isObj, propertiesObject[0].getAsJsonArray("parts_head_1"), positionDefinitionsArray, partsArray, doorMax, "NORMAL", "1", "%1");
                }
                catch (Exception modelObject2) {
                    // empty catch block
                }
                try {
                    this.processModel(currentCar, totalCars, isObj, propertiesObject[0].getAsJsonArray("parts_head_2"), positionDefinitionsArray, partsArray, doorMax, "NORMAL", "-1", "%1");
                }
                catch (Exception modelObject2) {
                    // empty catch block
                }
                try {
                    this.processModel(currentCar, totalCars, isObj, propertiesObject[0].getAsJsonArray("parts_head_1_headlights"), positionDefinitionsArray, partsArray, doorMax, "ON_ROUTE_FORWARDS", "1", "%1");
                }
                catch (Exception modelObject2) {
                    // empty catch block
                }
                try {
                    this.processModel(currentCar, totalCars, isObj, propertiesObject[0].getAsJsonArray("parts_head_2_headlights"), positionDefinitionsArray, partsArray, doorMax, "ON_ROUTE_BACKWARDS", "-1", "%1");
                }
                catch (Exception modelObject2) {
                    // empty catch block
                }
                try {
                    this.processModel(currentCar, totalCars, isObj, propertiesObject[0].getAsJsonArray("parts_head_1_tail_lights"), positionDefinitionsArray, partsArray, doorMax, "ON_ROUTE_BACKWARDS", "1", "%1");
                }
                catch (Exception modelObject2) {
                    // empty catch block
                }
                try {
                    this.processModel(currentCar, totalCars, isObj, propertiesObject[0].getAsJsonArray("parts_head_2_tail_lights"), positionDefinitionsArray, partsArray, doorMax, "ON_ROUTE_FORWARDS", "-1", "%1");
                }
                catch (Exception modelObject2) {
                    // empty catch block
                }
                try {
                    this.processModel(currentCar, totalCars, isObj, propertiesObject[0].getAsJsonArray("parts_end_1"), positionDefinitionsArray, partsArray, doorMax, "NORMAL", "%1", "1");
                }
                catch (Exception modelObject2) {
                    // empty catch block
                }
                try {
                    this.processModel(currentCar, totalCars, isObj, propertiesObject[0].getAsJsonArray("parts_end_2"), positionDefinitionsArray, partsArray, doorMax, "NORMAL", "%1", "-1");
                }
                catch (Exception modelObject2) {
                    // empty catch block
                }
                try {
                    this.processModel(currentCar, totalCars, isObj, propertiesObject[0].getAsJsonArray("parts_door_opened"), positionDefinitionsArray, partsArray, doorMax, "DOORS_OPENED", null, null);
                }
                catch (Exception modelObject2) {
                    // empty catch block
                }
                try {
                    this.processModel(currentCar, totalCars, isObj, propertiesObject[0].getAsJsonArray("parts_door_closed"), positionDefinitionsArray, partsArray, doorMax, "DOORS_CLOSED", null, null);
                }
                catch (Exception modelObject2) {
                    // empty catch block
                }
                try {
                    this.processModel(currentCar, totalCars, isObj, propertiesObject[0].getAsJsonArray("parts"), positionDefinitionsArray, partsArray, doorMax, null, null, null);
                }
                catch (Exception modelObject2) {
                    // empty catch block
                }
                JsonObject modelPropertiesObject = new JsonObject();
                modelPropertiesObject.addProperty("modelYOffset", 1);
                modelPropertiesObject.addProperty("gangwayInnerSideResource", (this.gangway_connection_id.isEmpty() ? this.texture_id : this.gangway_connection_id) + "_connector_side.png");
                modelPropertiesObject.addProperty("gangwayInnerTopResource", (this.gangway_connection_id.isEmpty() ? this.texture_id : this.gangway_connection_id) + "_connector_roof.png");
                modelPropertiesObject.addProperty("gangwayInnerBottomResource", (this.gangway_connection_id.isEmpty() ? this.texture_id : this.gangway_connection_id) + "_connector_floor.png");
                modelPropertiesObject.addProperty("gangwayOuterSideResource", (this.gangway_connection_id.isEmpty() ? this.texture_id : this.gangway_connection_id) + "_connector_exterior.png");
                modelPropertiesObject.addProperty("gangwayOuterTopResource", (this.gangway_connection_id.isEmpty() ? this.texture_id : this.gangway_connection_id) + "_connector_exterior.png");
                modelPropertiesObject.addProperty("gangwayOuterBottomResource", (this.gangway_connection_id.isEmpty() ? this.texture_id : this.gangway_connection_id) + "_connector_exterior.png");
                modelPropertiesObject.addProperty("gangwayWidth", 1.5);
                modelPropertiesObject.addProperty("gangwayHeight", 2.25);
                modelPropertiesObject.addProperty("gangwayYOffset", 1);
                modelPropertiesObject.addProperty("gangwayZOffset", 0.5);
                modelPropertiesObject.addProperty("barrierInnerSideResource", this.train_barrier_id + "_exterior.png");
                modelPropertiesObject.addProperty("barrierOuterSideResource", this.train_barrier_id + "_exterior.png");
                modelPropertiesObject.addProperty("barrierWidth", 2.25);
                modelPropertiesObject.addProperty("barrierHeight", 1);
                modelPropertiesObject.addProperty("barrierYOffset", 1.25);
                modelPropertiesObject.addProperty("barrierZOffset", 0.25);
                modelPropertiesObject.add("parts", partsArray);
                JsonObject positionDefinitionsObject = new JsonObject();
                positionDefinitionsObject.add("positionDefinitions", positionDefinitionsArray);
                double x1 = width / 2.0 + 0.25;
                double x2 = width / 2.0 + 0.5;
                double z = length / 2.0 - 0.5;
                ObjectArraySet<Box> doorways = new ObjectArraySet<Box>();
                for (double j = -z; j <= z + 0.001; j += 1.0) {
                    doorways.add(new Box(-x1, 1.0, j, -x2, 1.0, j + 1.0));
                    doorways.add(new Box(x1, 1.0, j, x2, 1.0, j + 1.0));
                }
                vehicleResources.add(new VehicleResource(new JsonReader(baseObject), modelObjects.stream().map(modelObject -> new VehicleModel(new JsonReader((JsonElement)modelObject), new ModelProperties(new JsonReader(modelPropertiesObject)), new PositionDefinitions(new JsonReader(positionDefinitionsObject)), id)).collect(Collectors.toCollection(ObjectArrayList::new)), new Box(-x1, 1.0, -z, x1, 1.0, z), doorways));
                continue;
            }
            baseObject.getAsJsonArray("models").forEach(jsonElement -> {
                JsonObject modelObject = jsonElement.getAsJsonObject();
                if (!LegacyVehicleResource.tryGet(modelObject, "textureResource").contains("overlay")) {
                    modelObject.addProperty("textureResource", this.texture_id);
                }
            });
            vehicleResources.add(new VehicleResource(new JsonReader(baseObject)));
        }
    }

    private void processModel(int currentCar, int totalCars, boolean isObj, JsonArray propertiesPartsArray, JsonArray positionDefinitionsArray, JsonArray partsArray, double doorMax, @Nullable String renderConditionOverride, @Nullable String whitelistedCarsOverride, @Nullable String blacklistedCarsOverride) {
        propertiesPartsArray.forEach(jsonElement -> {
            JsonObject propertiesPartsObject = jsonElement.getAsJsonObject();
            String[] whitelistedCarsFilters = (whitelistedCarsOverride == null ? LegacyVehicleResource.tryGet(propertiesPartsObject, "whitelisted_cars") : whitelistedCarsOverride).split(",");
            String[] blacklistedCarsFilters = (blacklistedCarsOverride == null ? LegacyVehicleResource.tryGet(propertiesPartsObject, "blacklisted_cars") : blacklistedCarsOverride).split(",");
            if (LegacyVehicleResource.matchesFilter(blacklistedCarsFilters, currentCar, totalCars) <= LegacyVehicleResource.matchesFilter(whitelistedCarsFilters, currentCar, totalCars)) {
                double doorZMultiplier;
                double doorXMultiplier;
                JsonObject partsObject = new JsonObject();
                partsArray.add(partsObject);
                if (propertiesPartsObject.has("name")) {
                    LegacyVehicleResource.addSingleArrayItem(partsObject, "names", LegacyVehicleResource.tryGet(propertiesPartsObject, "name"));
                } else {
                    LegacyVehicleResource.addSingleArrayItem(partsObject, "names", LegacyVehicleResource.tryGet(propertiesPartsObject, "part_name"));
                }
                partsObject.addProperty("renderStage", LegacyVehicleResource.tryGet(propertiesPartsObject, "stage").toUpperCase(Locale.ENGLISH));
                partsObject.addProperty("doorAnimationType", this.door_animation_type);
                if (renderConditionOverride == null) {
                    partsObject.addProperty("condition", switch (LegacyVehicleResource.tryGet(propertiesPartsObject, "render_condition").toUpperCase(Locale.ENGLISH)) {
                        case "DOORS_OPEN", "DOORS_LEFT_OPEN", "DOORS_RIGHT_OPEN" -> "DOORS_OPENED";
                        case "DOORS_CLOSED", "DOORS_LEFT_CLOSED", "DOORS_RIGHT_CLOSED" -> "DOORS_CLOSED";
                        case "MOVING_FORWARDS" -> "ON_ROUTE_FORWARDS";
                        case "MOVING_BACKWARDS" -> "ON_ROUTE_BACKWARDS";
                        default -> "NORMAL";
                    });
                } else {
                    partsObject.addProperty("condition", renderConditionOverride);
                }
                if (propertiesPartsObject.has("display")) {
                    partsObject.addProperty("type", "DISPLAY");
                } else {
                    partsObject.addProperty("type", "NORMAL");
                }
                if (propertiesPartsObject.has("door_offset")) {
                    switch (LegacyVehicleResource.tryGet(propertiesPartsObject, "door_offset").toUpperCase(Locale.ENGLISH)) {
                        case "LEFT_NEGATIVE": 
                        case "RIGHT_NEGATIVE": {
                            doorXMultiplier = -1.0;
                            doorZMultiplier = -doorMax;
                            break;
                        }
                        case "LEFT_POSITIVE": 
                        case "RIGHT_POSITIVE": {
                            doorXMultiplier = -1.0;
                            doorZMultiplier = doorMax;
                            break;
                        }
                        default: {
                            doorXMultiplier = 0.0;
                            doorZMultiplier = 0.0;
                            break;
                        }
                    }
                } else {
                    switch (LegacyVehicleResource.tryGet(propertiesPartsObject, "door_offset_x").toUpperCase(Locale.ENGLISH)) {
                        case "LEFT": 
                        case "LEFT_NEGATIVE": 
                        case "RIGHT": 
                        case "RIGHT_NEGATIVE": {
                            doorXMultiplier = -1.0;
                            break;
                        }
                        default: {
                            doorXMultiplier = 0.0;
                        }
                    }
                    switch (LegacyVehicleResource.tryGet(propertiesPartsObject, "door_offset_z").toUpperCase(Locale.ENGLISH)) {
                        case "LEFT_NEGATIVE": 
                        case "RIGHT_NEGATIVE": {
                            doorZMultiplier = -doorMax;
                            break;
                        }
                        case "LEFT": 
                        case "RIGHT": {
                            doorZMultiplier = doorMax;
                            break;
                        }
                        default: {
                            doorZMultiplier = 0.0;
                        }
                    }
                }
                partsObject.addProperty("doorXMultiplier", doorXMultiplier);
                partsObject.addProperty("doorZMultiplier", (double)(isObj ? -1 : 1) * doorZMultiplier);
                String positionDefinitionName = "definition_" + Integer.toHexString(new Random().nextInt());
                JsonArray positionDefinitionPositionsArray = new JsonArray();
                JsonArray positionDefinitionPositionsFlippedArray = new JsonArray();
                JsonObject positionDefinitionObject = new JsonObject();
                positionDefinitionObject.addProperty("name", positionDefinitionName);
                positionDefinitionObject.add("positions", positionDefinitionPositionsArray);
                positionDefinitionObject.add("positionsFlipped", positionDefinitionPositionsFlippedArray);
                positionDefinitionsArray.add(positionDefinitionObject);
                boolean mirror = propertiesPartsObject.has("mirror") && propertiesPartsObject.get("mirror").getAsBoolean();
                LegacyVehicleResource.processPositions(propertiesPartsObject, "positions", mirror ? positionDefinitionPositionsFlippedArray : positionDefinitionPositionsArray);
                LegacyVehicleResource.processPositions(propertiesPartsObject, "positions_flipped", positionDefinitionPositionsFlippedArray);
                LegacyVehicleResource.addSingleArrayItem(partsObject, "positionDefinitions", positionDefinitionName);
            }
        });
    }

    private static void processPositions(JsonObject propertiesPartsObject, String property, JsonArray positionDefinitionPositionsArray) {
        try {
            propertiesPartsObject.getAsJsonArray(property).forEach(jsonElement -> {
                JsonObject positionDefinitionObject = new JsonObject();
                positionDefinitionObject.addProperty("x", jsonElement.getAsJsonArray().get(0).getAsDouble());
                positionDefinitionObject.addProperty("z", jsonElement.getAsJsonArray().get(1).getAsDouble());
                positionDefinitionPositionsArray.add(positionDefinitionObject);
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void addSingleArrayItem(JsonObject jsonObject, String property, String string) {
        JsonArray jsonArray = new JsonArray();
        jsonArray.add(string);
        jsonObject.add(property, jsonArray);
    }

    private static String tryGet(JsonObject jsonObject, String property) {
        try {
            return jsonObject.get(property).getAsString();
        }
        catch (Exception ignored) {
            return "";
        }
    }

    private static int matchesFilter(String[] filters, int currentCar, int totalCars) {
        int strength = filters.length == 0 ? 1 : 0;
        for (String filter : filters) {
            if (filter.isEmpty()) continue;
            if (filter.contains("%")) {
                try {
                    int additional;
                    String[] filterSplit = filter.split("\\+");
                    int multiple = Integer.parseInt(filterSplit[0].replace("%", ""));
                    int n = additional = filterSplit.length == 1 ? 0 : Integer.parseInt(filterSplit[1]);
                    if ((currentCar + 1 + additional) % multiple != 0) continue;
                    strength = 2;
                }
                catch (Exception filterSplit) {}
                continue;
            }
            try {
                int car = Integer.parseInt(filter);
                if (car != currentCar + 1 && car != currentCar - totalCars) continue;
                return 3;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return strength;
    }

    private static String[] splitWithEmptyStrings(String string, char token) {
        String filler = Integer.toHexString(new Random().nextInt());
        String[] firstSplit = string.replace(String.valueOf(token), String.format("%1$s%2$s%1$s", filler, Character.valueOf(token))).split("\\" + token);
        String[] finalSplit = new String[firstSplit.length];
        for (int i = 0; i < firstSplit.length; ++i) {
            finalSplit[i] = firstSplit[i].replace(filler, "");
        }
        return finalSplit;
    }

    private static enum Variation {
        TRAILER(" (Trailer)"),
        CAB_1(" Cab (Forwards)"),
        CAB_2(" Cab (Backwards)"),
        CAB_3(" Cab (Double)");

        private final String key = this.toString().toLowerCase(Locale.ENGLISH);
        private final String description;

        private Variation(String description) {
            this.description = description;
        }
    }
}

