/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.holder;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.level.GameType;
import org.mtr.mapping.annotation.MappedMethod;

@ParametersAreNonnullByDefault
public enum GameMode {
    SURVIVAL(GameType.SURVIVAL),
    CREATIVE(GameType.CREATIVE),
    ADVENTURE(GameType.ADVENTURE),
    SPECTATOR(GameType.SPECTATOR);

    public final GameType data;

    private GameMode(GameType data) {
        this.data = data;
    }

    public static GameMode convert(@Nullable GameType data) {
        return data == null ? null : GameMode.values()[data.ordinal()];
    }

    @MappedMethod
    public final boolean equals(@Nullable GameMode data) {
        return data != null && this.data == data.data;
    }

    @Nonnull
    @MappedMethod
    public static GameMode byId(int arg0) {
        return GameMode.convert(GameType.m_46393_((int)arg0));
    }

    @MappedMethod
    public int getId() {
        return this.data.m_46392_();
    }

    @Nonnull
    @MappedMethod
    public static GameMode byName(String arg0) {
        return GameMode.convert(GameType.m_46400_((String)arg0));
    }

    @Nullable
    @MappedMethod
    public static GameMode byName(String arg0, @Nullable GameMode arg1) {
        GameType tempData = GameType.m_46402_((String)arg0, (GameType)(arg1 == null ? null : arg1.data));
        return tempData == null ? null : GameMode.convert(tempData);
    }

    @MappedMethod
    public boolean isCreative() {
        return this.data.m_46408_();
    }

    @Nonnull
    @MappedMethod
    public String getName() {
        return this.data.m_46405_();
    }

    @Nonnull
    @MappedMethod
    public static GameMode getDefaultMapped() {
        return GameMode.convert(GameType.f_151492_);
    }

    @Nonnull
    @MappedMethod
    public static GameMode getCreativeMapped() {
        return GameMode.convert(GameType.CREATIVE);
    }

    @Nonnull
    @MappedMethod
    public static GameMode getAdventureMapped() {
        return GameMode.convert(GameType.ADVENTURE);
    }

    @Nonnull
    @MappedMethod
    public static GameMode getSurvivalMapped() {
        return GameMode.convert(GameType.SURVIVAL);
    }

    @Nonnull
    @MappedMethod
    public static GameMode getSpectatorMapped() {
        return GameMode.convert(GameType.SPECTATOR);
    }
}

