/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.holder;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.BlockRotation;
import org.mtr.mapping.holder.Direction;

@ParametersAreNonnullByDefault
public enum Mirror {
    NONE(net.minecraft.world.level.block.Mirror.NONE),
    LEFT_RIGHT(net.minecraft.world.level.block.Mirror.LEFT_RIGHT),
    FRONT_BACK(net.minecraft.world.level.block.Mirror.FRONT_BACK);

    public final net.minecraft.world.level.block.Mirror data;

    private Mirror(net.minecraft.world.level.block.Mirror data) {
        this.data = data;
    }

    public static Mirror convert(@Nullable net.minecraft.world.level.block.Mirror data) {
        return data == null ? null : Mirror.values()[data.ordinal()];
    }

    @MappedMethod
    public final boolean equals(@Nullable Mirror data) {
        return data != null && this.data == data.data;
    }

    @Nonnull
    @MappedMethod
    public BlockRotation getRotation(Direction arg0) {
        return BlockRotation.convert(this.data.m_54846_(arg0.data));
    }

    @Nonnull
    @MappedMethod
    public Direction apply(Direction arg0) {
        return Direction.convert(this.data.m_54848_(arg0.data));
    }

    @MappedMethod
    public int mirror(int arg0, int arg1) {
        return this.data.m_54843_(arg0, arg1);
    }

    @Nonnull
    @MappedMethod
    public static Mirror getNoneMapped() {
        return Mirror.convert(net.minecraft.world.level.block.Mirror.NONE);
    }

    @Nonnull
    @MappedMethod
    public static Mirror getFrontBackMapped() {
        return Mirror.convert(net.minecraft.world.level.block.Mirror.FRONT_BACK);
    }

    @Nonnull
    @MappedMethod
    public static Mirror getLeftRightMapped() {
        return Mirror.convert(net.minecraft.world.level.block.Mirror.LEFT_RIGHT);
    }
}

