/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.holder;

import com.mojang.datafixers.DataFixer;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.mtr.mapping.annotation.MappedMethod;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.Chunk;
import org.mtr.mapping.holder.ChunkGenerator;
import org.mtr.mapping.holder.ChunkPos;
import org.mtr.mapping.holder.ChunkStatus;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldChunk;
import org.mtr.mapping.tool.HolderBase;

@ParametersAreNonnullByDefault
public final class ServerChunkManager
extends HolderBase<ServerChunkCache> {
    public ServerChunkManager(ServerChunkCache data) {
        super(data);
    }

    @MappedMethod
    public static ServerChunkManager cast(HolderBase<?> data) {
        return new ServerChunkManager((ServerChunkCache)data.data);
    }

    @MappedMethod
    public static boolean isInstance(@Nullable HolderBase<?> data) {
        return data != null && data.data instanceof ServerChunkCache;
    }

    @MappedMethod
    public boolean equals(@Nullable Object data) {
        return data instanceof HolderBase && ((ServerChunkCache)this.data).equals(((HolderBase)data).data);
    }

    @Nullable
    @MappedMethod
    public WorldChunk getWorldChunk(int arg0, int arg1) {
        LevelChunk tempData = ((ServerChunkCache)this.data).m_7131_(arg0, arg1);
        return tempData == null ? null : new WorldChunk(tempData);
    }

    @MappedMethod
    public void setChunkForced(ChunkPos arg0, boolean arg1) {
        ((ServerChunkCache)this.data).m_6692_((net.minecraft.world.level.ChunkPos)arg0.data, arg1);
    }

    @MappedMethod
    public void save(boolean arg0) {
        ((ServerChunkCache)this.data).m_8419_(arg0);
    }

    @MappedMethod
    public void markForUpdate(BlockPos arg0) {
        ((ServerChunkCache)this.data).m_8450_((net.minecraft.core.BlockPos)arg0.data);
    }

    @MappedMethod
    public void close() throws IOException {
        ((ServerChunkCache)this.data).close();
    }

    @MappedMethod
    public boolean executeQueuedTasks() {
        return ((ServerChunkCache)this.data).m_8466_();
    }

    @MappedMethod
    public void updatePosition(ServerPlayerEntity arg0) {
        ((ServerChunkCache)this.data).m_8385_((ServerPlayer)arg0.data);
    }

    @Nullable
    @MappedMethod
    public Chunk getChunk(int arg0, int arg1, ChunkStatus arg2, boolean arg3) {
        ChunkAccess tempData = ((ServerChunkCache)this.data).m_7587_(arg0, arg1, (net.minecraft.world.level.chunk.ChunkStatus)arg2.data, arg3);
        return tempData == null ? null : new Chunk(tempData);
    }

    @Nonnull
    @MappedMethod
    public World getWorld() {
        return new World(((ServerChunkCache)this.data).m_7653_());
    }

    @Nonnull
    @MappedMethod
    public String getChunkLoadingDebugInfo(ChunkPos arg0) {
        return ((ServerChunkCache)this.data).m_8448_((net.minecraft.world.level.ChunkPos)arg0.data);
    }

    @Deprecated
    public ServerChunkManager(ServerWorld arg0, LevelStorageSource.LevelStorageAccess arg1, DataFixer arg2, StructureTemplateManager arg3, Executor arg4, ChunkGenerator arg5, int arg6, int arg7, boolean arg8, ChunkProgressListener arg9, ChunkStatusUpdateListener arg10, Supplier<DimensionDataStorage> arg11) {
        super(new ServerChunkCache((ServerLevel)arg0.data, arg1, arg2, arg3, arg4, (net.minecraft.world.level.chunk.ChunkGenerator)arg5.data, arg6, arg7, arg8, arg9, arg10, arg11));
    }

    @Nonnull
    @MappedMethod
    public ChunkGenerator getChunkGenerator() {
        return new ChunkGenerator(((ServerChunkCache)this.data).m_8481_());
    }

    @Nonnull
    @MappedMethod
    public String getDebugString() {
        return ((ServerChunkCache)this.data).m_6754_();
    }

    @MappedMethod
    public boolean isChunkLoaded(int arg0, int arg1) {
        return ((ServerChunkCache)this.data).m_5563_(arg0, arg1);
    }

    @MappedMethod
    public void setMobSpawnOptions(boolean arg0, boolean arg1) {
        ((ServerChunkCache)this.data).m_6707_(arg0, arg1);
    }

    @Nullable
    @MappedMethod
    public WorldChunk getWorldChunk(int arg0, int arg1, boolean arg2) {
        LevelChunk tempData = ((ServerChunkCache)this.data).m_62227_(arg0, arg1, arg2);
        return tempData == null ? null : new WorldChunk(tempData);
    }
}

