/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.render.shader;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.apache.commons.io.IOUtils;
import org.mtr.mapping.holder.ResourceManager;
import org.mtr.mapping.render.tool.GlStateTracker;
import org.mtr.mapping.tool.DummyClass;

public final class PatchingResourceProvider
implements ResourceProvider {
    private final ResourceProvider resourceFactory;

    public PatchingResourceProvider(ResourceManager resourceManager) {
        this.resourceFactory = (ResourceProvider)resourceManager.data;
    }

    public Optional<Resource> m_213713_(ResourceLocation identifier) {
        ResourceLocation newIdentifier = identifier.m_135815_().contains("_modelmat") ? new ResourceLocation(identifier.m_135827_(), identifier.m_135815_().replace("_modelmat", "")) : identifier;
        Optional resource = this.resourceFactory.m_213713_(newIdentifier);
        if (resource.isEmpty()) {
            return Optional.empty();
        }
        try {
            String returningContent;
            InputStream inputStream2 = ((Resource)resource.get()).m_215507_();
            if (newIdentifier.m_135815_().endsWith(".json")) {
                JsonObject dataObject = JsonParser.parseString((String)IOUtils.toString((InputStream)inputStream2, (Charset)StandardCharsets.UTF_8)).getAsJsonObject();
                inputStream2.close();
                dataObject.addProperty("vertex", dataObject.get("vertex").getAsString() + "_modelmat");
                JsonArray attributeArray = dataObject.get("attributes").getAsJsonArray();
                for (int i = 0; i < 6 - attributeArray.size(); ++i) {
                    attributeArray.add("Dummy" + i);
                }
                attributeArray.add("ModelMat");
                returningContent = dataObject.toString();
            } else if (newIdentifier.m_135815_().endsWith(".vsh")) {
                returningContent = PatchingResourceProvider.patchVertexShaderSource(IOUtils.toString((InputStream)inputStream2, (Charset)StandardCharsets.UTF_8));
                inputStream2.close();
            } else {
                return resource;
            }
            return Optional.of(new Resource(((Resource)resource.get()).m_215506_(), () -> new ByteArrayInputStream(returningContent.getBytes(StandardCharsets.UTF_8))));
        }
        catch (Exception e) {
            DummyClass.logException(e);
            return Optional.empty();
        }
    }

    private static String patchVertexShaderSource(String sourceContent) {
        String[] contentParts = sourceContent.split("void main");
        contentParts[0] = contentParts[0].replace("uniform mat4 ModelViewMat;", "uniform mat4 ModelViewMat;\nin mat4 ModelMat;");
        if (GlStateTracker.isGl4ES()) {
            contentParts[0] = contentParts[0].replace("ivec2", "vec2");
        }
        contentParts[1] = contentParts[1].replaceAll("\\bPosition\\b", "(MODELVIEWMAT * ModelMat * vec4(Position, 1.0)).xyz").replaceAll("\\bNormal\\b", "normalize(mat3(MODELVIEWMAT * ModelMat) * Normal)").replace("ModelViewMat", "mat4(1.0)").replace("MODELVIEWMAT", "ModelViewMat");
        return contentParts[0] + "void main" + contentParts[1];
    }
}

