/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mapping.tool;

import java.lang.reflect.Executable;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.mtr.mapping.annotation.MappedMethod;

public final class EnumHelper {
    private static final Set<String> SIGNATURES = Arrays.stream(Enum.class.getMethods()).map(EnumHelper::quickSerialize).collect(Collectors.toSet());

    @MappedMethod
    public static boolean containsSignature(Executable executable) {
        return SIGNATURES.contains(EnumHelper.quickSerialize(executable));
    }

    private static String quickSerialize(Executable executable) {
        Type[] types = executable.getGenericParameterTypes();
        String[] typesString = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            typesString[i] = types[i].getTypeName();
        }
        return EnumHelper.quickSerialize(executable.getModifiers(), executable.getName(), typesString);
    }

    private static String quickSerialize(int modifiers, String name, String ... parameters) {
        return String.format("%s %s %s", modifiers, name, String.join((CharSequence)",", parameters));
    }

    static {
        SIGNATURES.add(EnumHelper.quickSerialize(1, "equals", "java.lang.Object"));
        SIGNATURES.add(EnumHelper.quickSerialize(9, "values", new String[0]));
        SIGNATURES.add(EnumHelper.quickSerialize(9, "valueOf", "java.lang.String"));
    }
}

