/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod;

import com.mojang.brigadier.arguments.StringArgumentType;
import java.io.File;
import java.net.ServerSocket;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.world.level.Level;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mtr.core.Main;
import org.mtr.core.data.Position;
import org.mtr.core.operation.GenerateOrClearByDepotName;
import org.mtr.core.operation.SetTime;
import org.mtr.core.servlet.Webserver;
import org.mtr.core.simulation.Simulator;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.org.eclipse.jetty.servlet.ServletHolder;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ChunkManager;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MathHelper;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldSavePath;
import org.mtr.mapping.mapper.GameRule;
import org.mtr.mapping.mapper.MinecraftServerHelper;
import org.mtr.mapping.mapper.WorldHelper;
import org.mtr.mapping.registry.CommandBuilder;
import org.mtr.mapping.registry.Registry;
import org.mtr.mapping.tool.DummyClass;
import org.mtr.mod.AsciiArt;
import org.mtr.mod.BlockEntityTypes;
import org.mtr.mod.Blocks;
import org.mtr.mod.CreativeModeTabs;
import org.mtr.mod.EntityTypes;
import org.mtr.mod.Items;
import org.mtr.mod.SoundEvents;
import org.mtr.mod.config.Config;
import org.mtr.mod.data.ArrivalsCacheServer;
import org.mtr.mod.data.RailActionModule;
import org.mtr.mod.packet.PacketAddBalance;
import org.mtr.mod.packet.PacketBroadcastRailActions;
import org.mtr.mod.packet.PacketDeleteData;
import org.mtr.mod.packet.PacketDeleteRailAction;
import org.mtr.mod.packet.PacketDepotClear;
import org.mtr.mod.packet.PacketDepotGenerate;
import org.mtr.mod.packet.PacketDriveTrain;
import org.mtr.mod.packet.PacketFetchArrivals;
import org.mtr.mod.packet.PacketForwardClientRequest;
import org.mtr.mod.packet.PacketOpenBlockEntityScreen;
import org.mtr.mod.packet.PacketOpenDashboardScreen;
import org.mtr.mod.packet.PacketOpenLiftCustomizationScreen;
import org.mtr.mod.packet.PacketOpenPIDSConfigScreen;
import org.mtr.mod.packet.PacketOpenTicketMachineScreen;
import org.mtr.mod.packet.PacketPressLiftButton;
import org.mtr.mod.packet.PacketRequestData;
import org.mtr.mod.packet.PacketTurnOnBlockEntity;
import org.mtr.mod.packet.PacketUpdateData;
import org.mtr.mod.packet.PacketUpdateEyeCandyConfig;
import org.mtr.mod.packet.PacketUpdateLastRailStyles;
import org.mtr.mod.packet.PacketUpdateLiftTrackFloorConfig;
import org.mtr.mod.packet.PacketUpdatePIDSConfig;
import org.mtr.mod.packet.PacketUpdateRailwaySignConfig;
import org.mtr.mod.packet.PacketUpdateSignalConfig;
import org.mtr.mod.packet.PacketUpdateTrainAnnouncerConfig;
import org.mtr.mod.packet.PacketUpdateTrainScheduleSensorConfig;
import org.mtr.mod.packet.PacketUpdateTrainSensorConfig;
import org.mtr.mod.packet.PacketUpdateVehicleRidingEntities;
import org.mtr.mod.packet.PacketUpdateVehiclesLifts;
import org.mtr.mod.servlet.Tunnel;
import org.mtr.mod.servlet.VehicleLiftServlet;

public final class Init
implements Utilities {
    private static Main main;
    private static Webserver webserver;
    private static Tunnel tunnel;
    private static int serverPort;
    private static Runnable sendWorldTimeUpdate;
    private static boolean canSendWorldTimeUpdate;
    private static int serverTick;
    public static final String MOD_ID = "mtr";
    public static final String MOD_ID_NTE = "mtrsteamloco";
    public static final Logger LOGGER;
    public static final Registry REGISTRY;
    public static final int SECONDS_PER_MC_HOUR = 50;
    private static final int MILLIS_PER_MC_DAY = 1200000;
    private static final Object2ObjectArrayMap<ServerWorld, RailActionModule> RAIL_ACTION_MODULES;
    private static final ObjectArrayList<String> WORLD_ID_LIST;

    public static void init() {
        AsciiArt.print();
        Blocks.init();
        Items.init();
        BlockEntityTypes.init();
        EntityTypes.init();
        CreativeModeTabs.init();
        SoundEvents.init();
        DummyClass.enableLogging();
        REGISTRY.setupPackets(new Identifier(MOD_ID, "packet"));
        REGISTRY.registerPacket(PacketAddBalance.class, PacketAddBalance::new);
        REGISTRY.registerPacket(PacketBroadcastRailActions.class, PacketBroadcastRailActions::new);
        REGISTRY.registerPacket(PacketDeleteData.class, PacketDeleteData::new);
        REGISTRY.registerPacket(PacketDeleteRailAction.class, PacketDeleteRailAction::new);
        REGISTRY.registerPacket(PacketDepotClear.class, PacketDepotClear::new);
        REGISTRY.registerPacket(PacketDepotGenerate.class, PacketDepotGenerate::new);
        REGISTRY.registerPacket(PacketDriveTrain.class, PacketDriveTrain::new);
        REGISTRY.registerPacket(PacketFetchArrivals.class, PacketFetchArrivals::new);
        REGISTRY.registerPacket(PacketForwardClientRequest.class, PacketForwardClientRequest::new);
        REGISTRY.registerPacket(PacketOpenBlockEntityScreen.class, PacketOpenBlockEntityScreen::new);
        REGISTRY.registerPacket(PacketOpenDashboardScreen.class, PacketOpenDashboardScreen::new);
        REGISTRY.registerPacket(PacketOpenLiftCustomizationScreen.class, PacketOpenLiftCustomizationScreen::new);
        REGISTRY.registerPacket(PacketOpenPIDSConfigScreen.class, PacketOpenPIDSConfigScreen::new);
        REGISTRY.registerPacket(PacketOpenTicketMachineScreen.class, PacketOpenTicketMachineScreen::new);
        REGISTRY.registerPacket(PacketPressLiftButton.class, PacketPressLiftButton::new);
        REGISTRY.registerPacket(PacketRequestData.class, PacketRequestData::new);
        REGISTRY.registerPacket(PacketTurnOnBlockEntity.class, PacketTurnOnBlockEntity::new);
        REGISTRY.registerPacket(PacketUpdateData.class, PacketUpdateData::new);
        REGISTRY.registerPacket(PacketUpdateEyeCandyConfig.class, PacketUpdateEyeCandyConfig::new);
        REGISTRY.registerPacket(PacketUpdateLastRailStyles.class, PacketUpdateLastRailStyles::new);
        REGISTRY.registerPacket(PacketUpdateLiftTrackFloorConfig.class, PacketUpdateLiftTrackFloorConfig::new);
        REGISTRY.registerPacket(PacketUpdatePIDSConfig.class, PacketUpdatePIDSConfig::new);
        REGISTRY.registerPacket(PacketUpdateRailwaySignConfig.class, PacketUpdateRailwaySignConfig::new);
        REGISTRY.registerPacket(PacketUpdateSignalConfig.class, PacketUpdateSignalConfig::new);
        REGISTRY.registerPacket(PacketUpdateTrainAnnouncerConfig.class, PacketUpdateTrainAnnouncerConfig::new);
        REGISTRY.registerPacket(PacketUpdateTrainScheduleSensorConfig.class, PacketUpdateTrainScheduleSensorConfig::new);
        REGISTRY.registerPacket(PacketUpdateTrainSensorConfig.class, PacketUpdateTrainSensorConfig::new);
        REGISTRY.registerPacket(PacketUpdateVehiclesLifts.class, PacketUpdateVehiclesLifts::new);
        REGISTRY.registerPacket(PacketUpdateVehicleRidingEntities.class, PacketUpdateVehicleRidingEntities::new);
        REGISTRY.registerCommand(MOD_ID, commandBuilderMtr -> {
            commandBuilderMtr.then("generate", commandBuilderGenerate -> Init.generateOrClearDepotsFromCommand(commandBuilderGenerate, true));
            commandBuilderMtr.then("clear", commandBuilderClear -> Init.generateOrClearDepotsFromCommand(commandBuilderClear, false));
            commandBuilderMtr.then("forceCopyWorld", commandBuilderForceCopy -> {
                commandBuilderForceCopy.permissionLevel(4);
                commandBuilderForceCopy.then("worldDirectory", StringArgumentType.string(), innerCommandBuilder1 -> innerCommandBuilder1.then("backupDirectory", StringArgumentType.string(), innerCommandBuilder2 -> innerCommandBuilder2.executes(contextHandler -> {
                    Path runPath = contextHandler.getServer().getRunDirectory().toPath();
                    Path worldDirectory = runPath.resolve(contextHandler.getString("worldDirectory"));
                    Path backupDirectory = runPath.resolve(contextHandler.getString("backupDirectory"));
                    boolean worldDirectoryExists = Files.isDirectory(worldDirectory, new LinkOption[0]);
                    boolean backupDirectoryExists = Files.isDirectory(backupDirectory, new LinkOption[0]);
                    if (worldDirectoryExists && backupDirectoryExists) {
                        try {
                            if (main != null) {
                                main.stop();
                            }
                            if (webserver != null) {
                                webserver.stop();
                            }
                            contextHandler.sendSuccess(String.format("Restoring world backup from %s to %s...", backupDirectory, worldDirectory), true, new Object[0]);
                            FileUtils.deleteDirectory((File)worldDirectory.toFile());
                            contextHandler.sendSuccess("Deleting world complete", true, new Object[0]);
                            FileUtils.copyDirectory((File)backupDirectory.toFile(), (File)worldDirectory.toFile());
                            contextHandler.sendSuccess("Restoring world backup complete", true, new Object[0]);
                            System.exit(0);
                            return 1;
                        }
                        catch (Exception e) {
                            contextHandler.sendFailure("Restoring world backup failed", new Object[0]);
                            LOGGER.error("", (Throwable)e);
                            return -1;
                        }
                    }
                    if (backupDirectoryExists) {
                        contextHandler.sendFailure("World directory not found", new Object[0]);
                    } else if (worldDirectoryExists) {
                        contextHandler.sendFailure("Backup directory not found", new Object[0]);
                    } else {
                        contextHandler.sendFailure("Directories not found", new Object[0]);
                    }
                    return -1;
                })));
            });
        }, "minecrafttransitrailway");
        Init.REGISTRY.eventRegistry.registerServerStarted(minecraftServer -> {
            RAIL_ACTION_MODULES.clear();
            WORLD_ID_LIST.clear();
            MinecraftServerHelper.iterateWorlds(minecraftServer, serverWorld -> {
                RAIL_ACTION_MODULES.put((ServerWorld)serverWorld, new RailActionModule((ServerWorld)serverWorld));
                WORLD_ID_LIST.add(Init.getWorldId(new World((Level)serverWorld.data)));
            });
            Config.init(minecraftServer.getRunDirectory());
            int defaultPort = Config.getServer().getWebserverPort();
            serverPort = Init.findFreePort(defaultPort);
            tunnel = new Tunnel(minecraftServer.getRunDirectory(), defaultPort, () -> {});
            int port = Init.findFreePort(serverPort + 1);
            main = new Main(minecraftServer.getSavePath(WorldSavePath.getRootMapped()).resolve(MOD_ID), serverPort, port, WORLD_ID_LIST.toArray(new String[0]));
            webserver = new Webserver(port);
            webserver.addServlet(new ServletHolder(new VehicleLiftServlet((MinecraftServer)minecraftServer)), "/vehicles-lifts");
            webserver.start();
            serverTick = 0;
            sendWorldTimeUpdate = () -> {
                if (canSendWorldTimeUpdate) {
                    canSendWorldTimeUpdate = false;
                    Init.sendHttpRequest("operation/set-time", null, Utilities.getJsonObjectFromData(new SetTime((WorldHelper.getTimeOfDay(minecraftServer.getOverworld()) + 6000L) * 50L, 1200000L, GameRule.DO_DAYLIGHT_CYCLE.getBooleanGameRule((MinecraftServer)minecraftServer))).toString(), response -> {
                        canSendWorldTimeUpdate = true;
                    });
                } else {
                    Main.LOGGER.error("Transport Simulation Core not responding; stopping Minecraft server!");
                    if (main != null) {
                        main.stop();
                    }
                    if (webserver != null) {
                        webserver.stop();
                    }
                    Main.LOGGER.error("Shutting down all threads");
                    System.exit(0);
                }
            };
        });
        Init.REGISTRY.eventRegistry.registerServerStopping(minecraftServer -> {
            if (tunnel != null) {
                tunnel.stop();
            }
            if (main != null) {
                main.stop();
            }
            if (webserver != null) {
                webserver.stop();
            }
        });
        Init.REGISTRY.eventRegistry.registerStartServerTick(() -> {
            if (sendWorldTimeUpdate != null && serverTick % 500 == 0) {
                sendWorldTimeUpdate.run();
            }
            ArrivalsCacheServer.tickAll();
            ++serverTick;
        });
        Init.REGISTRY.eventRegistry.registerEndWorldTick(serverWorld -> {
            RailActionModule railActionModule = RAIL_ACTION_MODULES.get(serverWorld);
            if (railActionModule != null) {
                railActionModule.tick();
            }
        });
        REGISTRY.init();
    }

    public static void getRailActionModule(ServerWorld serverWorld, Consumer<RailActionModule> consumer) {
        RailActionModule railActionModule = RAIL_ACTION_MODULES.get(serverWorld);
        if (railActionModule != null) {
            consumer.accept(railActionModule);
        }
    }

    public static void sendHttpRequest(String endpoint, @Nullable String content, @Nullable Consumer<String> consumer) {
        Simulator.REQUEST_HELPER.sendRequest(String.format("http://localhost:%s%s", serverPort, endpoint), content, consumer);
    }

    public static void sendHttpRequest(String endpoint, @Nullable World world, String content, @Nullable Consumer<String> consumer) {
        Init.sendHttpRequest(String.format("/mtr/api/%s?%s", endpoint, world == null ? "dimensions=all" : "dimension=" + WORLD_ID_LIST.indexOf(Init.getWorldId(world))), content, consumer);
    }

    public static BlockPos positionToBlockPos(Position position) {
        return new BlockPos((int)position.getX(), (int)position.getY(), (int)position.getZ());
    }

    public static Position blockPosToPosition(BlockPos blockPos) {
        return new Position(blockPos.getX(), blockPos.getY(), blockPos.getZ());
    }

    public static BlockPos newBlockPos(double x, double y, double z) {
        return new BlockPos(MathHelper.floor(x), MathHelper.floor(y), MathHelper.floor(z));
    }

    public static boolean isChunkLoaded(World world, ChunkManager chunkManager, BlockPos blockPos) {
        return chunkManager.getWorldChunk(blockPos.getX() / 16, blockPos.getZ() / 16) != null && world.isRegionLoaded(blockPos, blockPos);
    }

    public static String getWorldId(World world) {
        Identifier identifier = MinecraftServerHelper.getWorldId(world);
        return String.format("%s/%s", identifier.getNamespace(), identifier.getPath());
    }

    public static String getTunnelUrl() {
        return tunnel.getTunnelUrl();
    }

    public static int findFreePort(int startingPort) {
        int i = Math.max(1024, startingPort);
        while (i <= 65535) {
            int n;
            ServerSocket serverSocket = new ServerSocket(i == 1024 ? 80 : i);
            try {
                int port = serverSocket.getLocalPort();
                LOGGER.info("Found available port: {}", (Object)port);
                n = port;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        serverSocket.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    ++i;
                }
            }
            serverSocket.close();
            return n;
        }
        return 0;
    }

    private static void generateOrClearDepotsFromCommand(CommandBuilder<?> commandBuilder, boolean isGenerate) {
        commandBuilder.permissionLevel(2);
        commandBuilder.executes(contextHandler -> {
            contextHandler.sendSuccess(isGenerate ? "command.mtr.generate_all" : "command.mtr.clear_all", true, new Object[0]);
            return Init.generateOrClearDepotsFromCommand(contextHandler.getWorld(), "", isGenerate);
        });
        commandBuilder.then("name", StringArgumentType.greedyString(), innerCommandBuilder -> innerCommandBuilder.executes(contextHandler -> {
            String filter = contextHandler.getString("name");
            contextHandler.sendSuccess(isGenerate ? "command.mtr.generate_filter" : "command.mtr.clear_filter", true, filter);
            return Init.generateOrClearDepotsFromCommand(contextHandler.getWorld(), filter, isGenerate);
        }));
    }

    private static int generateOrClearDepotsFromCommand(World world, String filter, boolean isGenerate) {
        GenerateOrClearByDepotName generateByDepotName = new GenerateOrClearByDepotName();
        generateByDepotName.setFilter(filter);
        Init.sendHttpRequest(isGenerate ? "operation/generate-by-depot-name" : "operation/clear-by-depot-name", world, Utilities.getJsonObjectFromData(generateByDepotName).toString(), null);
        return 1;
    }

    static {
        canSendWorldTimeUpdate = true;
        LOGGER = LogManager.getLogger((String)"MinecraftTransitRailway");
        REGISTRY = new Registry();
        RAIL_ACTION_MODULES = new Object2ObjectArrayMap();
        WORLD_ID_LIST = new ObjectArrayList();
    }
}

