/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.mtr.libraries.com.google.gson.JsonArray;
import org.mtr.libraries.com.google.gson.JsonElement;
import org.mtr.libraries.com.google.gson.JsonObject;
import org.mtr.libraries.com.google.gson.JsonParser;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mod.Init;
import org.mtr.mod.Keys;
import org.mtr.mod.data.IGui;
import org.mtr.mod.data.RailType;

public class Patreon
implements Keys,
IGui,
Comparable<Patreon> {
    public final String name;
    public final String tierTitle;
    public final int tierAmount;
    public final int tierColor;
    private final int totalAmount;
    public static final ObjectArrayList<Patreon> LIST = new ObjectArrayList();

    public Patreon(JsonObject jsonObjectPatron, JsonObject jsonObjectTiers) {
        this.name = jsonObjectPatron.get("full_name").getAsString();
        this.totalAmount = jsonObjectPatron.get("lifetime_support_cents").getAsInt();
        this.tierTitle = jsonObjectTiers.get("title").getAsString();
        this.tierAmount = jsonObjectTiers.get("amount_cents").getAsInt();
        int color = -1;
        try {
            color = RailType.valueOf((String)this.tierTitle.toUpperCase((Locale)Locale.ENGLISH)).color | 0xFF000000;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tierColor = color;
    }

    public static void getPatreonList() {
        LIST.clear();
        if (!"cXJEOrhz7TpFGtTi5prvBQaFKHa3-FKnQUz1PiBTPwc".isEmpty()) {
            CompletableFuture.runAsync(() -> Patreon.openConnectionSafeJson("https://www.patreon.com/api/oauth2/v2/campaigns/7782318/members?include=currently_entitled_tiers&fields%5Bmember%5D=full_name,lifetime_support_cents,patron_status&fields%5Btier%5D=title,amount_cents&page%5Bcount%5D=2147483647", jsonElement -> {
                JsonObject jsonObjectData = jsonElement.getAsJsonObject();
                Object2ObjectAVLTreeMap idMap = new Object2ObjectAVLTreeMap();
                jsonObjectData.getAsJsonArray("included").forEach(jsonElementData -> {
                    JsonObject jsonObject = jsonElementData.getAsJsonObject();
                    idMap.put(jsonObject.get("id").getAsString(), jsonObject.getAsJsonObject("attributes"));
                });
                jsonObjectData.getAsJsonArray("data").forEach(jsonElementData -> {
                    JsonObject jsonObjectAttributes = jsonElementData.getAsJsonObject().getAsJsonObject("attributes");
                    JsonArray jsonObjectTiers = jsonElementData.getAsJsonObject().getAsJsonObject("relationships").getAsJsonObject("currently_entitled_tiers").getAsJsonArray("data");
                    if (!jsonObjectAttributes.get("patron_status").isJsonNull() && jsonObjectAttributes.get("patron_status").getAsString().equals("active_patron") && !jsonObjectTiers.isEmpty()) {
                        LIST.add(new Patreon(jsonObjectAttributes, (JsonObject)idMap.get(jsonObjectTiers.get(0).getAsJsonObject().get("id").getAsString())));
                    }
                });
                Collections.sort(LIST);
            }, "Authorization", "Bearer cXJEOrhz7TpFGtTi5prvBQaFKHa3-FKnQUz1PiBTPwc"));
        }
    }

    public static void openConnectionSafe(String url, Consumer<InputStream> callback, String ... requestProperties) {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setUseCaches(false);
            for (int i = 0; i < requestProperties.length / 2; ++i) {
                connection.setRequestProperty(requestProperties[2 * i], requestProperties[2 * i + 1]);
            }
            try (InputStream inputStream2 = connection.getInputStream();){
                callback.accept(inputStream2);
            }
            catch (Exception e) {
                Init.LOGGER.error("", (Throwable)e);
            }
        }
        catch (Exception e) {
            Init.LOGGER.error("", (Throwable)e);
        }
    }

    public static void openConnectionSafeJson(String url, Consumer<JsonElement> callback, String ... requestProperties) {
        Patreon.openConnectionSafe(url, inputStream2 -> {
            try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream2, StandardCharsets.UTF_8);){
                callback.accept(JsonParser.parseReader(inputStreamReader));
            }
            catch (Exception e) {
                Init.LOGGER.error("", (Throwable)e);
            }
        }, requestProperties);
    }

    @Override
    public int compareTo(Patreon patreon) {
        return patreon.tierAmount == this.tierAmount ? patreon.totalAmount - this.totalAmount : patreon.tierAmount - this.tierAmount;
    }
}

