/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod;

import java.net.Inet4Address;
import javax.annotation.Nullable;
import org.mtr.core.Main;
import org.mtr.libraries.io.nayuki.qrcodegen.QrCode;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;

public final class QrCodeHelper
implements IGui {
    @Nullable
    private QrCode qrCode;
    private String serverTunnelUrl = "";
    private String clientTunnelUrl = "";
    private String defaultTunnelUrl = "";
    public static final QrCodeHelper INSTANCE = new QrCodeHelper();

    public void setServerTunnelUrl(String url) {
        if (!url.isEmpty() && !url.equals(this.serverTunnelUrl)) {
            this.serverTunnelUrl = url;
            this.update();
        }
    }

    public void setClientTunnelUrl(int defaultPort, String url) {
        this.clientTunnelUrl = url;
        try {
            this.defaultTunnelUrl = String.format("%s://%s:%s", "http", Inet4Address.getLocalHost().getHostAddress(), defaultPort);
        }
        catch (Exception e) {
            Main.LOGGER.error("", (Throwable)e);
            this.defaultTunnelUrl = "http://localhost:" + defaultPort;
        }
        this.update();
    }

    private void update() {
        String url = this.serverTunnelUrl.isEmpty() ? (this.clientTunnelUrl.isEmpty() ? this.defaultTunnelUrl : this.clientTunnelUrl) : this.serverTunnelUrl;
        this.qrCode = QrCode.encodeText(url, QrCode.Ecc.MEDIUM);
    }

    public void renderQrCode(StoredMatrixTransformations storedMatrixTransformations, QueuedRenderLayer queuedRenderLayer, float size) {
        QrCodeHelper.renderQrCode(this.qrCode, storedMatrixTransformations, queuedRenderLayer, size);
    }

    public static void renderQrCode(@Nullable QrCode qrCode, StoredMatrixTransformations storedMatrixTransformations, QueuedRenderLayer queuedRenderLayer, float size) {
        int padding = 4;
        MainRenderer.scheduleRender(new Identifier("mtr", "textures/block/white.png"), false, queuedRenderLayer, (graphicsHolder, offset) -> {
            storedMatrixTransformations.transform((GraphicsHolder)graphicsHolder, (Vector3d)offset);
            if (qrCode == null) {
                IDrawing.drawTexture(graphicsHolder, 0.0f, 0.0f, size, size, Direction.UP, GraphicsHolder.getDefaultLight());
            } else {
                int pixels = qrCode.size;
                int pixelsWithPadding = pixels + 8;
                graphicsHolder.scale(size / (float)pixelsWithPadding, size / (float)pixelsWithPadding, 0.0f);
                for (int x = 0; x < pixels; ++x) {
                    for (int y = 0; y < pixels; ++y) {
                        IDrawing.drawTexture(graphicsHolder, x + 4, y + 4, 0.0f, x + 4 + 1, y + 4 + 1, 0.0f, Direction.UP, qrCode.getModule(x, y) ? -16777216 : -1, GraphicsHolder.getDefaultLight());
                    }
                }
                IDrawing.drawTexture(graphicsHolder, 0.0f, 0.0f, pixelsWithPadding, 4.0f, Direction.UP, GraphicsHolder.getDefaultLight());
                IDrawing.drawTexture(graphicsHolder, 0.0f, 4.0f, 4.0f, pixelsWithPadding - 8, Direction.UP, GraphicsHolder.getDefaultLight());
                IDrawing.drawTexture(graphicsHolder, pixelsWithPadding - 4, 4.0f, 4.0f, pixelsWithPadding - 8, Direction.UP, GraphicsHolder.getDefaultLight());
                IDrawing.drawTexture(graphicsHolder, 0.0f, pixelsWithPadding - 4, pixelsWithPadding, 4.0f, Direction.UP, GraphicsHolder.getDefaultLight());
            }
            graphicsHolder.pop();
        });
    }
}

