/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import java.util.List;
import javax.annotation.Nonnull;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Blocks;
import org.mtr.mapping.holder.BooleanBiFunction;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.VoxelShapes;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.BlockEscalatorBase;
import org.mtr.mod.block.BlockEscalatorStep;
import org.mtr.mod.block.IBlock;

public class BlockEscalatorSide
extends BlockEscalatorBase {
    @Override
    @Nonnull
    public BlockState getStateForNeighborUpdate2(BlockState state, Direction direction, BlockState neighborState, WorldAccess world, BlockPos pos, BlockPos neighborPos) {
        if (direction == Direction.DOWN && !(world.getBlockState((BlockPos)pos.down()).getBlock().data instanceof BlockEscalatorStep)) {
            return Blocks.getAirMapped().getDefaultState();
        }
        return super.getStateForNeighborUpdate2(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    @Nonnull
    public VoxelShape getCollisionShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        return VoxelShapes.combine(this.getOutlineShape2(state, world, pos, context), super.getCollisionShape2(state, world, pos, context), BooleanBiFunction.getAndMapped());
    }

    @Override
    @Nonnull
    public VoxelShape getCameraCollisionShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        return VoxelShapes.empty();
    }

    @Override
    public void onBreak2(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        BlockPos offsetPos = pos.down();
        if (IBlock.getStatePropertySafe(state, SIDE) == IBlock.EnumSide.RIGHT) {
            offsetPos = offsetPos.offset(IBlock.getSideDirection(state));
        }
        IBlock.onBreakCreative(world, player, offsetPos);
        super.onBreak2(world, pos, state, player);
    }

    @Override
    @Nonnull
    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        BlockEscalatorBase.EnumEscalatorOrientation orientation = this.getOrientation(world, pos, state);
        boolean isBottom = orientation == BlockEscalatorBase.EnumEscalatorOrientation.LANDING_BOTTOM;
        boolean isTop = orientation == BlockEscalatorBase.EnumEscalatorOrientation.LANDING_TOP;
        boolean isRight = IBlock.getStatePropertySafe(state, SIDE) == IBlock.EnumSide.RIGHT;
        return IBlock.getVoxelShapeByDirection(isRight ? 12.0 : 0.0, 0.0, isTop ? 8.0 : 0.0, isRight ? 16.0 : 4.0, 16.0, isBottom ? 8.0 : 16.0, IBlock.getStatePropertySafe(state, FACING));
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add(FACING);
        properties.add(ORIENTATION);
        properties.add(SIDE);
    }
}

