/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import java.util.List;
import javax.annotation.Nonnull;
import org.mtr.core.tool.Vector;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.mapper.BlockExtension;
import org.mtr.mapping.mapper.BlockHelper;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.IBlock;

public abstract class BlockLiftTrackBase
extends BlockExtension
implements DirectionHelper {
    public BlockLiftTrackBase() {
        super(BlockHelper.createBlockSettings(true));
    }

    @Override
    @Nonnull
    public BlockState getPlacementState2(ItemPlacementContext context) {
        return this.getDefaultState2().with(new Property((net.minecraft.world.level.block.state.properties.Property)BlockLiftTrackBase.FACING.data), BlockLiftTrackBase.getFacing((ItemPlacementContext)context).data);
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add(FACING);
    }

    public abstract ObjectArrayList<Direction> getConnectingDirections(BlockState var1);

    public Vector getCenterPoint(BlockPos blockPos, BlockState blockState) {
        return new Vector(blockPos.getX(), blockPos.getY(), blockPos.getZ());
    }

    protected static Direction getFacing(ItemPlacementContext context) {
        Direction oppositeFace = context.getSide().getOpposite();
        if (oppositeFace.getOffsetY() == 0) {
            return oppositeFace;
        }
        BlockState state = context.getWorld().getBlockState(context.getBlockPos().offset(oppositeFace));
        if (state.getBlock().data instanceof BlockLiftTrackBase) {
            return IBlock.getStatePropertySafe(state, FACING);
        }
        return context.getPlayerFacing();
    }
}

