/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.state.properties.Property;
import org.mtr.core.tool.Utilities;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockRenderType;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Blocks;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.VoxelShapes;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.BlockWithEntity;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.BlockPSDAPGBase;
import org.mtr.mod.block.BlockPSDAPGGlassEndBase;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.data.IGui;

public abstract class BlockPSDAPGDoorBase
extends BlockPSDAPGBase
implements BlockWithEntity {
    public static final BooleanProperty END = BooleanProperty.of("end");
    public static final BooleanProperty UNLOCKED = BooleanProperty.of("unlocked");

    @Override
    @Nonnull
    public BlockState getStateForNeighborUpdate2(BlockState state, Direction direction, BlockState neighborState, WorldAccess world, BlockPos pos, BlockPos neighborPos) {
        if (IBlock.getSideDirection(state) == direction && !neighborState.isOf(new Block(this))) {
            return Blocks.getAirMapped().getDefaultState();
        }
        BlockState superState = super.getStateForNeighborUpdate2(state, direction, neighborState, world, pos, neighborPos);
        if (superState.getBlock().equals(Blocks.getAirMapped())) {
            return superState;
        }
        boolean end = world.getBlockState((BlockPos)pos.offset((Direction)IBlock.getSideDirection((BlockState)state).getOpposite())).getBlock().data instanceof BlockPSDAPGGlassEndBase;
        return superState.with(new org.mtr.mapping.holder.Property((Property)BlockPSDAPGDoorBase.END.data), end);
    }

    @Override
    public void onBreak2(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        BlockPos offsetPos = pos;
        if (IBlock.getStatePropertySafe(state, HALF) == IBlock.DoubleBlockHalf.UPPER) {
            offsetPos = offsetPos.down();
        }
        if (IBlock.getStatePropertySafe(state, SIDE) == IBlock.EnumSide.RIGHT) {
            offsetPos = offsetPos.offset(IBlock.getSideDirection(state));
        }
        IBlock.onBreakCreative(world, player, offsetPos);
        super.onBreak2(world, pos, state, player);
    }

    @Override
    @Nonnull
    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        return IBlock.checkHoldingBrush(world, player, () -> {
            boolean unlocked = IBlock.getStatePropertySafe(state, UNLOCKED);
            for (int y = -1; y <= 1; ++y) {
                BlockState scanState = world.getBlockState(pos.up(y));
                if (!state.isOf(scanState.getBlock())) continue;
                BlockPSDAPGDoorBase.lockDoor(world, pos.up(y), scanState, !unlocked);
            }
            player.sendMessage(new Text((Component)(!unlocked ? TextHelper.translatable((String)"gui.mtr.psd_apg_door_unlocked", (Object[])new Object[0]) : TextHelper.translatable((String)"gui.mtr.psd_apg_door_locked", (Object[])new Object[0])).data), true);
        });
    }

    @Override
    @Nonnull
    public VoxelShape getCollisionShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        BlockEntity entity = world.getBlockEntity(pos);
        if (entity != null && entity.data instanceof BlockEntityBase && entity.getWorld().isClient() && ((BlockEntityBase)entity.data).doorValue == 0.0) {
            return super.getCollisionShape2(state, world, pos, context);
        }
        return VoxelShapes.empty();
    }

    @Override
    @Nonnull
    public BlockRenderType getRenderType2(BlockState state) {
        return BlockRenderType.getEntityblockAnimatedMapped();
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add(END);
        properties.add(FACING);
        properties.add(HALF);
        properties.add(SIDE);
        properties.add(UNLOCKED);
    }

    private static void lockDoor(World world, BlockPos pos, BlockState state, boolean unlocked) {
        BlockState toggled;
        Direction facing = IBlock.getStatePropertySafe(state, FACING);
        BlockPos leftPos = pos.offset(facing.rotateYCounterclockwise());
        BlockPos rightPos = pos.offset(facing.rotateYClockwise());
        BlockState leftState = world.getBlockState(leftPos);
        BlockState rightState = world.getBlockState(rightPos);
        if (leftState.isOf(state.getBlock())) {
            toggled = leftState.with(new org.mtr.mapping.holder.Property((Property)BlockPSDAPGDoorBase.UNLOCKED.data), unlocked);
            world.setBlockState(leftPos, toggled);
        }
        if (rightState.isOf(state.getBlock())) {
            toggled = rightState.with(new org.mtr.mapping.holder.Property((Property)BlockPSDAPGDoorBase.UNLOCKED.data), unlocked);
            world.setBlockState(rightPos, toggled);
        }
        world.setBlockState(pos, state.with(new org.mtr.mapping.holder.Property((Property)BlockPSDAPGDoorBase.UNLOCKED.data), unlocked));
    }

    public static abstract class BlockEntityBase
    extends BlockEntityExtension
    implements IGui {
        private double doorValue;

        public BlockEntityBase(BlockEntityType<?> type, BlockPos pos, BlockState state) {
            super(type, pos, state);
        }

        public void open(double vehicleDoorValue) {
            this.doorValue = Utilities.clamp(vehicleDoorValue * 2.0, 0.0, 1.0);
        }

        public double getDoorValue() {
            return this.doorValue;
        }
    }
}

