/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.level.block.state.properties.Property;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.EnumProperty;
import org.mtr.mapping.holder.IntegerProperty;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.StringIdentifiable;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.VoxelShapes;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mapping.mapper.BlockExtension;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.BlockAPGDoor;
import org.mtr.mod.block.BlockAPGGlass;
import org.mtr.mod.block.BlockAPGGlassEnd;
import org.mtr.mod.block.BlockPSDAPGDoorBase;
import org.mtr.mod.block.BlockPSDDoor;
import org.mtr.mod.block.BlockPSDGlass;
import org.mtr.mod.block.BlockPSDGlassEnd;
import org.mtr.mod.block.IBlock;

public class BlockPlatform
extends BlockExtension
implements DirectionHelper {
    private final boolean isIndented;
    public static final EnumProperty<EnumDoorType> DOOR_TYPE = EnumProperty.of("door_type", EnumDoorType.class);
    public static final IntegerProperty SIDE = IntegerProperty.of("side", 0, 4);

    public BlockPlatform(BlockSettings blockSettings, boolean isIndented) {
        super(blockSettings);
        this.isIndented = isIndented;
    }

    @Override
    @Nonnull
    public BlockState getStateForNeighborUpdate2(BlockState state, Direction direction, BlockState neighborState, WorldAccess world, BlockPos pos, BlockPos neighborPos) {
        return this.getActualState(BlockView.cast(world), pos, state);
    }

    @Override
    public BlockState getPlacementState2(ItemPlacementContext ctx) {
        return this.getDefaultState2().with(new org.mtr.mapping.holder.Property((Property)BlockPlatform.FACING.data), ctx.getPlayerFacing().data);
    }

    @Override
    @Nonnull
    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        if (this.isIndented) {
            Direction facing = IBlock.getStatePropertySafe(state, FACING);
            return VoxelShapes.union(IBlock.getVoxelShapeByDirection(0.0, 0.0, 6.0, 16.0, 13.0, 16.0, facing), Block.createCuboidShape(0.0, 13.0, 0.0, 16.0, 16.0, 16.0));
        }
        return super.getOutlineShape2(state, world, pos, context);
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add(FACING);
        properties.add(DOOR_TYPE);
        properties.add(SIDE);
    }

    private BlockState getActualState(BlockView world, BlockPos pos, BlockState state) {
        int side;
        EnumDoorType doorType;
        Direction facing = IBlock.getStatePropertySafe(state, FACING);
        BlockState stateAbove = world.getBlockState(pos.up());
        Block blockAbove = stateAbove.getBlock();
        if (blockAbove.data instanceof BlockPSDDoor || blockAbove.data instanceof BlockPSDGlass || blockAbove.data instanceof BlockPSDGlassEnd) {
            doorType = EnumDoorType.PSD;
            facing = IBlock.getStatePropertySafe(stateAbove, FACING);
        } else if (blockAbove.data instanceof BlockAPGDoor || blockAbove.data instanceof BlockAPGGlass || blockAbove.data instanceof BlockAPGGlassEnd) {
            doorType = EnumDoorType.APG;
            facing = IBlock.getStatePropertySafe(stateAbove, FACING);
        } else {
            doorType = EnumDoorType.NONE;
        }
        boolean aboveIsDoor = blockAbove.data instanceof BlockPSDAPGDoorBase;
        BlockState stateLeftAbove = world.getBlockState(pos.up().offset(facing.rotateYCounterclockwise()));
        boolean leftAboveIsDoor = stateLeftAbove.getBlock().data instanceof BlockPSDAPGDoorBase;
        BlockState stateRightAbove = world.getBlockState(pos.up().offset(facing.rotateYClockwise()));
        boolean rightAboveIsDoor = stateRightAbove.getBlock().data instanceof BlockPSDAPGDoorBase;
        if (aboveIsDoor && rightAboveIsDoor) {
            side = 2;
        } else if (aboveIsDoor && leftAboveIsDoor) {
            side = 3;
        } else if (rightAboveIsDoor) {
            side = 1;
            facing = IBlock.getStatePropertySafe(stateRightAbove, FACING);
        } else if (leftAboveIsDoor) {
            side = 4;
            facing = IBlock.getStatePropertySafe(stateLeftAbove, FACING);
        } else {
            side = 0;
        }
        return state.with(new org.mtr.mapping.holder.Property((Property)BlockPlatform.FACING.data), facing.data).with(new org.mtr.mapping.holder.Property((Property)BlockPlatform.DOOR_TYPE.data), doorType).with(new org.mtr.mapping.holder.Property((Property)BlockPlatform.SIDE.data), side);
    }

    private static enum EnumDoorType implements StringIdentifiable
    {
        NONE("none"),
        PSD("psd"),
        APG("apg");

        private final String name;

        private EnumDoorType(String nameIn) {
            this.name = nameIn;
        }

        @Override
        @Nonnull
        public String asString2() {
            return this.name;
        }
    }
}

