/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.block;

import java.util.List;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.IntegerProperty;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.Random;
import org.mtr.mapping.holder.ServerWorld;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.BlockTrainSensorBase;
import org.mtr.mod.block.IBlock;

public abstract class BlockTrainPoweredSensorBase
extends BlockTrainSensorBase {
    public static final IntegerProperty POWERED = IntegerProperty.of("powered", 0, 2);
    private static final int UPDATE_TICKS = 10;

    @Override
    public void scheduledTick2(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        int oldPowered = IBlock.getStatePropertySafe(state, POWERED);
        if (oldPowered > 0) {
            world.setBlockState(pos, state.with(new Property((net.minecraft.world.level.block.state.properties.Property)BlockTrainPoweredSensorBase.POWERED.data), oldPowered - 1));
            if (!BlockTrainPoweredSensorBase.hasScheduledTick(World.cast(world), pos, new Block(this))) {
                BlockTrainPoweredSensorBase.scheduleBlockTick(World.cast(world), pos, new Block(this), 10);
            }
        }
    }

    @Override
    public boolean emitsRedstonePower2(BlockState blockState) {
        return true;
    }

    @Override
    public int getWeakRedstonePower2(BlockState state, BlockView world, BlockPos pos, Direction direction) {
        return IBlock.getStatePropertySafe(state, POWERED) > 0 ? 15 : 0;
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add(POWERED);
    }

    public void power(World world, BlockState state, BlockPos pos) {
        int oldPowered = IBlock.getStatePropertySafe(state, POWERED);
        if (oldPowered < 2) {
            world.setBlockState(pos, state.with(new Property((net.minecraft.world.level.block.state.properties.Property)BlockTrainPoweredSensorBase.POWERED.data), 2));
            if (oldPowered == 0 && !BlockTrainPoweredSensorBase.hasScheduledTick(world, pos, new Block(this))) {
                BlockTrainPoweredSensorBase.scheduleBlockTick(world, pos, new Block(this), 10);
            }
        }
    }
}

