/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.client;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import org.mtr.core.data.TransportMode;
import org.mtr.core.tool.Utilities;
import org.mtr.legacy.resource.CustomResourcesConverter;
import org.mtr.libraries.com.google.gson.JsonElement;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectList;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.mapper.ResourceManagerHelper;
import org.mtr.mod.Init;
import org.mtr.mod.Keys;
import org.mtr.mod.config.Config;
import org.mtr.mod.resource.CustomResources;
import org.mtr.mod.resource.ObjectResource;
import org.mtr.mod.resource.OptimizedRendererWrapper;
import org.mtr.mod.resource.RailResource;
import org.mtr.mod.resource.SignResource;
import org.mtr.mod.resource.VehicleResource;

public class CustomResourceLoader {
    private static long TEST_DURATION;
    public static final OptimizedRendererWrapper OPTIMIZED_RENDERER_WRAPPER;
    public static final String CUSTOM_RESOURCES_ID = "mtr_custom_resources";
    public static final String DEFAULT_RAIL_ID = "default";
    public static final String DEFAULT_RAIL_3D_ID = "default_3d";
    public static final String DEFAULT_RAIL_3D_SIDING_ID = "default_3d_siding";
    private static final Object2ObjectAVLTreeMap<String, JsonElement> RESOURCE_CACHE;
    private static final Object2ObjectAVLTreeMap<TransportMode, ObjectArrayList<VehicleResource>> VEHICLES;
    private static final Object2ObjectAVLTreeMap<TransportMode, Object2ObjectAVLTreeMap<String, VehicleResource>> VEHICLES_CACHE;
    private static final ObjectArrayList<SignResource> SIGNS;
    private static final Object2ObjectAVLTreeMap<String, SignResource> SIGNS_CACHE;
    private static final ObjectArrayList<RailResource> RAILS;
    private static final Object2ObjectAVLTreeMap<String, RailResource> RAILS_CACHE;
    private static final ObjectArrayList<ObjectResource> OBJECTS;
    private static final Object2ObjectAVLTreeMap<String, ObjectResource> OBJECTS_CACHE;

    public static void reload() {
        OPTIMIZED_RENDERER_WRAPPER.beginReload();
        RESOURCE_CACHE.clear();
        VEHICLES.forEach((transportMode, vehicleResources) -> vehicleResources.clear());
        VEHICLES_CACHE.forEach((transportMode, vehicleResourcesCache) -> vehicleResourcesCache.clear());
        SIGNS.clear();
        SIGNS_CACHE.clear();
        RAILS.clear();
        RAILS_CACHE.clear();
        OBJECTS.clear();
        OBJECTS_CACHE.clear();
        TEST_DURATION = 0L;
        RailResource defaultRailResource = new RailResource(DEFAULT_RAIL_ID, "Default");
        RAILS.add(defaultRailResource);
        RAILS_CACHE.put(DEFAULT_RAIL_ID, defaultRailResource);
        ResourceManagerHelper.readAllResources(new Identifier("mtr", "mtr_custom_resources.json"), inputStream2 -> {
            try {
                CustomResources customResources = CustomResourcesConverter.convert(Config.readResource(inputStream2).getAsJsonObject());
                customResources.iterateVehicles(vehicleResource -> {
                    VEHICLES.get((Object)vehicleResource.getTransportMode()).add((VehicleResource)vehicleResource);
                    VEHICLES_CACHE.get((Object)vehicleResource.getTransportMode()).put(vehicleResource.getId(), (VehicleResource)vehicleResource);
                });
                customResources.iterateSigns(signResource -> {
                    SIGNS.add((SignResource)signResource);
                    SIGNS_CACHE.put(signResource.getId(), (SignResource)signResource);
                });
                customResources.iterateRails(railResource -> {
                    RAILS.add((RailResource)railResource);
                    RAILS_CACHE.put(railResource.getId(), (RailResource)railResource);
                });
                customResources.iterateObjects(objectResource -> {
                    OBJECTS.add((ObjectResource)objectResource);
                    OBJECTS_CACHE.put(objectResource.getId(), (ObjectResource)objectResource);
                });
            }
            catch (Exception e) {
                Init.LOGGER.error("", (Throwable)e);
            }
        });
        CustomResourcesConverter.convertRails(railResource -> {
            RAILS.add((RailResource)railResource);
            RAILS_CACHE.put(railResource.getId(), (RailResource)railResource);
        });
        CustomResourcesConverter.convertObjects(objectResource -> {
            OBJECTS.add((ObjectResource)objectResource);
            OBJECTS_CACHE.put(objectResource.getId(), (ObjectResource)objectResource);
        });
        OPTIMIZED_RENDERER_WRAPPER.finishReload();
        Init.LOGGER.info("Loaded {} vehicles and completed door movement validation in {} ms", (Object)VEHICLES.values().stream().mapToInt(ObjectArrayList::size).reduce(0, Integer::sum), (Object)((double)TEST_DURATION / 1000000.0));
        Init.LOGGER.info("Loaded {} signs", (Object)SIGNS.size());
        Init.LOGGER.info("Loaded {} rails", (Object)RAILS.size());
        Init.LOGGER.info("Loaded {} objects", (Object)OBJECTS.size());
    }

    public static void iterateVehicles(TransportMode transportMode, Consumer<VehicleResource> consumer) {
        VEHICLES.get((Object)transportMode).forEach(consumer);
    }

    public static void getVehicleByIndex(TransportMode transportMode, int index, Consumer<VehicleResource> ifPresent) {
        VehicleResource vehicleResource;
        if (index >= 0 && (vehicleResource = (VehicleResource)Utilities.getElement(VEHICLES.get((Object)transportMode), index)) != null) {
            ifPresent.accept(vehicleResource);
        }
    }

    public static void getVehicleById(TransportMode transportMode, String vehicleId, Consumer<VehicleResource> ifPresent) {
        VehicleResource vehicleResource = VEHICLES_CACHE.get((Object)transportMode).get(vehicleId);
        if (vehicleResource != null) {
            ifPresent.accept(vehicleResource);
        }
    }

    public static void getSignById(String signId, Consumer<SignResource> ifPresent) {
        SignResource signResource = SIGNS_CACHE.get(signId);
        if (signResource != null) {
            ifPresent.accept(signResource);
        }
    }

    public static ObjectArrayList<String> getSortedSignIds() {
        ObjectArrayList<String> signIds = new ObjectArrayList<String>(SIGNS_CACHE.keySet());
        signIds.sort(String::compareTo);
        return signIds;
    }

    public static ObjectImmutableList<RailResource> getRails() {
        return new ObjectImmutableList<RailResource>((ObjectList<RailResource>)RAILS);
    }

    public static void getRailById(String railId, Consumer<RailResource> ifPresent) {
        RailResource railResource = RAILS_CACHE.get(railId);
        if (railResource != null) {
            ifPresent.accept(railResource);
        }
    }

    public static ObjectImmutableList<ObjectResource> getObjects() {
        return new ObjectImmutableList<ObjectResource>((ObjectList<ObjectResource>)OBJECTS);
    }

    public static void getObjectById(String objectId, Consumer<ObjectResource> ifPresent) {
        ObjectResource objectResource = OBJECTS_CACHE.get(objectId);
        if (objectResource != null) {
            ifPresent.accept(objectResource);
        }
    }

    public static void readResource(@Nullable Identifier identifier, Consumer<JsonElement> consumer) {
        if (identifier != null) {
            String identifierString = ((ResourceLocation)identifier.data).toString();
            JsonElement jsonElement = RESOURCE_CACHE.get(identifierString);
            if (jsonElement == null) {
                if (Keys.DEBUG) {
                    try (InputStream inputStream3 = Files.newInputStream(MinecraftClient.getInstance().getRunDirectoryMapped().toPath().resolve("../src/main/resources/assets").resolve(identifier.getNamespace()).resolve(identifier.getPath()), StandardOpenOption.READ);){
                        JsonElement newJsonElement = Config.readResource(inputStream3);
                        consumer.accept(newJsonElement);
                        RESOURCE_CACHE.put(identifierString, newJsonElement);
                    }
                    catch (Exception e) {
                        Init.LOGGER.error("", (Throwable)e);
                    }
                } else {
                    ResourceManagerHelper.readResource(identifier, (InputStream inputStream2) -> {
                        JsonElement newJsonElement = Config.readResource(inputStream2);
                        consumer.accept(newJsonElement);
                        RESOURCE_CACHE.put(identifierString, newJsonElement);
                    });
                }
            } else {
                consumer.accept(jsonElement);
            }
        }
    }

    public static void incrementTestDuration(long duration) {
        TEST_DURATION += duration;
    }

    static {
        OPTIMIZED_RENDERER_WRAPPER = new OptimizedRendererWrapper();
        RESOURCE_CACHE = new Object2ObjectAVLTreeMap();
        VEHICLES = new Object2ObjectAVLTreeMap();
        VEHICLES_CACHE = new Object2ObjectAVLTreeMap();
        SIGNS = new ObjectArrayList();
        SIGNS_CACHE = new Object2ObjectAVLTreeMap();
        RAILS = new ObjectArrayList();
        RAILS_CACHE = new Object2ObjectAVLTreeMap();
        OBJECTS = new ObjectArrayList();
        OBJECTS_CACHE = new Object2ObjectAVLTreeMap();
        for (TransportMode transportMode : TransportMode.values()) {
            VEHICLES.put(transportMode, new ObjectArrayList());
            VEHICLES_CACHE.put(transportMode, new Object2ObjectAVLTreeMap());
        }
    }
}

