/*
 * Decompiled with CFR 0.152.
 */
package org.mtr.mod.client;

import org.mtr.core.data.TransportMode;

public class Oscillation {
    private double amount;
    private double amplitude;
    private double scheduledAmplitude;
    private long time;
    private final boolean enabled;
    private static final long PERIOD = 1000L;
    private static final double PERIOD_MULTIPLIER = 0.006283185307179587;
    private static final double DAMPING = 2000.0;

    public Oscillation(TransportMode transportMode) {
        this.enabled = transportMode != TransportMode.AIRPLANE;
    }

    public void tick(long millisElapsed) {
        if (this.enabled) {
            long oldTime = this.time;
            this.time += millisElapsed;
            if (this.scheduledAmplitude > 0.0 && (oldTime == 0L || oldTime % 1000L > this.time % 1000L)) {
                this.amplitude = this.scheduledAmplitude;
                this.scheduledAmplitude = 0.0;
            }
            this.amount = this.amplitude * Math.sin(0.006283185307179587 * (double)this.time);
            if (this.amplitude > 0.01) {
                this.amplitude /= Math.exp((double)millisElapsed / 2000.0);
            } else {
                this.amplitude = 0.0;
                this.time = 0L;
            }
        }
    }

    public void startOscillation(double magnitude) {
        this.scheduledAmplitude = magnitude;
    }

    public double getAmount() {
        return this.enabled ? this.amount : 0.0;
    }
}

